package main

import (
	"log"

	"code.justin.tv/common/config"
	"code.justin.tv/common/twitchhttp"
	"code.justin.tv/live/yt-live-annotations/app/api"
	"code.justin.tv/live/yt-live-annotations/backend"
	"code.justin.tv/live/yt-live-annotations/youtube"
)

func main() {
	log.SetPrefix("yt: ")
	config.Register(map[string]string{
		"table-name": "yt-annotations-staging",
	})

	err := config.Parse()
	if err != nil {
		log.Fatal(err)
	}

	b, err := backend.New(config.MustResolve("table-name"))
	if err != nil {
		log.Fatal(err)
	}

	yt, err := youtube.New()
	if err != nil {
		log.Fatal(err)
	}

	server, err := api.NewServer(b, yt)
	if err != nil {
		log.Fatal(err)
	}

	log.Fatal(twitchhttp.ListenAndServe(server))
}
