package youtube_annotations

import (
	"fmt"
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/common/twitchhttp"

	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestGet(t *testing.T) {
	Convey("when calling Get", t, func() {
		ts := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			if r.URL.Path == "/enabled/123" && r.Method == "GET" {
				fmt.Fprintln(w, `{
					"enabled": true
				}`)
			}
		}))
		defer ts.Close()

		j, err := NewClient(twitchhttp.ClientConf{Host: ts.URL})
		if err != nil {
			t.Fatal(err)
		}

		res, err := j.GetYoutubeAnnotationsEnabled(context.Background(), "123", nil)

		So(err, ShouldBeNil)
		So(res.Enabled, ShouldBeTrue)
	})
}

func TestEnable(t *testing.T) {
	Convey("when calling Enable", t, func() {
		ts := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			if r.URL.Path == "/enabled/123" && r.Method == "POST" {
				fmt.Fprintln(w, `{
					"enabled": true
				}`)
			}
		}))
		defer ts.Close()

		j, err := NewClient(twitchhttp.ClientConf{Host: ts.URL})
		if err != nil {
			t.Fatal(err)
		}

		res, err := j.EnableYoutubeAnnotations(context.Background(), "123", nil)

		So(err, ShouldBeNil)
		So(res.Enabled, ShouldBeTrue)
	})
}

func TestDisable(t *testing.T) {
	Convey("when calling Enable", t, func() {
		ts := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			if r.URL.Path == "/enabled/123" && r.Method == "DELETE" {
				fmt.Fprintln(w, `{
					"enabled": false
				}`)
			}
		}))
		defer ts.Close()

		j, err := NewClient(twitchhttp.ClientConf{Host: ts.URL})
		if err != nil {
			t.Fatal(err)
		}

		res, err := j.DisableYoutubeAnnotations(context.Background(), "123", nil)

		So(err, ShouldBeNil)
		So(res.Enabled, ShouldBeFalse)
	})
}

func TestClearAnnotations(t *testing.T) {
	Convey("when calling ClearAnnotations", t, func() {
		ts := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			if r.URL.Path == "/annotations/123" && r.Method == "DELETE" {
				fmt.Fprintln(w, `OK`)
			}
		}))
		defer ts.Close()

		j, err := NewClient(twitchhttp.ClientConf{Host: ts.URL})
		if err != nil {
			t.Fatal(err)
		}

		err = j.ClearYoutubeAnnotations(context.Background(), "123", nil)

		So(err, ShouldBeNil)
	})
}
