job {
    name 'live-yt-live-annotations'
    using 'TEMPLATE-autobuild'
    concurrentBuild true

    scm {
        git {
            remote {
                github 'live/yt-live-annotations', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    wrappers {
        sshAgent 'git-aws-read-key'
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }

    steps {
        shell 'cp app/Dockerfile Dockerfile_app; cp worker/Dockerfile Dockerfile_worker'
        shell './scripts/build.sh'
        shell './scripts/push.sh'
        saveDeployArtifact 'live/yt-live-annotations-ebextensions', 'app/deploy/'
        saveDeployArtifact 'live/yt-live-annotations-worker-ebextensions', 'worker/deploy/'
    }
}

freeStyleJob('live-yt-live-annotations-production-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'live/yt-live-annotations-ebextensions'
        shell 'rm *.manifest*'

        // deploy server
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/live-yt-live-annotations:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy production-api""".stripMargin()
    }
}

freeStyleJob('live-yt-live-annotations-production-worker-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'live/yt-live-annotations-worker-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/live-yt-live-annotations-worker:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy production-worker""".stripMargin()
    }
}

freeStyleJob('live-yt-live-annotations-staging-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'live/yt-live-annotations-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/live-yt-live-annotations:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy staging-api""".stripMargin()
    }
}

freeStyleJob('live-yt-live-annotations-staging-worker-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'live/yt-live-annotations-worker-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/live-yt-live-annotations-worker:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "ContainerPort": "8000"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy staging-worker""".stripMargin()
    }
}
