variable "name" {}
variable "sns_account" {
  default = 465369119046
}

resource "aws_sqs_queue" "worker_queue" {
  name = "${var.name}"
  policy = <<END_OF_STRING
{
  "Version": "2012-10-17",
  "Id": "arn:aws:sqs:us-west-2:924637445623:${var.name}/Policy",
  "Statement": [
    {
      "Sid": "",
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::924637445623:root"
      },
      "Action": "SQS:*",
      "Resource": "arn:aws:sqs:us-west-2:924637445623:${var.name}"
    },
    {
      "Sid": "",
      "Effect": "Allow",
      "Principal": "*",
      "Action": "SQS:SendMessage",
      "Resource": "arn:aws:sqs:us-west-2:924637445623:${var.name}",
      "Condition": {
        "ArnLike": {
          "aws:SourceArn": "arn:aws:sns:us-west-2:641044725657:notification-stream-change-*"
        }
      }
    }
  ]
}
END_OF_STRING
}
