package api

import (
	"net/http"
	"testing"

	"code.justin.tv/live/yt-live-annotations/worker/api/mocks"

	"github.com/cactus/go-statsd-client/statsd"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func Test_cleanup(t *testing.T) {
	Convey("works", t, func() {
		ctx := context.Background()
		backend := &mocks.Backend{}
		s := &Server{
			backend: backend,
			stats:   &statsd.NoopClient{},
		}
		r, _ := http.NewRequest("POST", "/cleanup", nil)

		ch := make(chan string)
		errCh := make(chan error)

		backend.On("ScanAnnotationsEnabledUsers").Return(ch, errCh)

		close(ch)
		close(errCh)

		w := makeTestRequest(s.cleanupJob, ctx, r)

		So(w.Code, ShouldEqual, http.StatusOK)
	})
}
