package mocks

import context "golang.org/x/net/context"
import mock "github.com/stretchr/testify/mock"

// Backend is an autogenerated mock type for the Backend type
type Backend struct {
	mock.Mock
}

// DisableAnnotations provides a mock function with given fields: ctx, userID
func (_m *Backend) DisableAnnotations(ctx context.Context, userID string) error {
	ret := _m.Called(ctx, userID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetAnnotationsEnabled provides a mock function with given fields: ctx, userID
func (_m *Backend) GetAnnotationsEnabled(ctx context.Context, userID string) (bool, error) {
	ret := _m.Called(ctx, userID)

	var r0 bool
	if rf, ok := ret.Get(0).(func(context.Context, string) bool); ok {
		r0 = rf(ctx, userID)
	} else {
		r0 = ret.Get(0).(bool)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ScanAnnotationsEnabledUsers provides a mock function with given fields:
func (_m *Backend) ScanAnnotationsEnabledUsers() (chan string, chan error) {
	ret := _m.Called()

	var r0 chan string
	if rf, ok := ret.Get(0).(func() chan string); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(chan string)
		}
	}

	var r1 chan error
	if rf, ok := ret.Get(1).(func() chan error); ok {
		r1 = rf()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(chan error)
		}
	}

	return r0, r1
}

// ScanAnnotationsEnabledUsersAll provides a mock function with given fields:
func (_m *Backend) ScanAnnotationsEnabledUsersAll() (chan string, chan error) {
	ret := _m.Called()

	var r0 chan string
	if rf, ok := ret.Get(0).(func() chan string); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(chan string)
		}
	}

	var r1 chan error
	if rf, ok := ret.Get(1).(func() chan error); ok {
		r1 = rf()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(chan error)
		}
	}

	return r0, r1
}

// UpdateAnnotationsTimestamp provides a mock function with given fields: ctx, userID
func (_m *Backend) UpdateAnnotationsTimestamp(ctx context.Context, userID string) error {
	ret := _m.Called(ctx, userID)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, userID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
