package main

import (
	"log"

	"code.justin.tv/common/config"
	"code.justin.tv/common/twitchhttp"
	"code.justin.tv/live/yt-live-annotations/backend"
	"code.justin.tv/live/yt-live-annotations/worker/api"
	"code.justin.tv/live/yt-live-annotations/youtube"
	"code.justin.tv/web/jax/client"
)

func main() {
	log.SetPrefix("yt: ")
	config.Register(map[string]string{
		"table-name": "yt-annotations-staging",
		"jax-url":    "http://jax-internal-staging.us-west2.justin.tv",
	})

	err := config.Parse()
	if err != nil {
		log.Fatal(err)
	}

	b, err := backend.New(config.MustResolve("table-name"))
	if err != nil {
		log.Fatal(err)
	}

	yt, err := youtube.New()
	if err != nil {
		log.Fatal(err)
	}

	jax, err := jax.NewClient(twitchhttp.ClientConf{
		Host:           config.MustResolve("jax-url"),
		TimingXactName: "jax",
		Stats:          config.Statsd(),
		Transport: twitchhttp.TransportConf{
			MaxIdleConnsPerHost: 10,
		},
	})
	if err != nil {
		log.Fatal(err)
	}

	server, err := api.NewServer(b, yt, jax)
	if err != nil {
		log.Fatal(err)
	}

	log.Fatal(twitchhttp.ListenAndServe(server))
}
