package config

import "code.justin.tv/chat/jsonconf"

type Config struct {
	Port int `json:"port" validate:"min=1"`

	Stats     StatsConfig    `json:"stats"`
	DynamoDB  DynamoDBConfig `json:"dynamodb"`
	S3        S3Config       `json:"s3"`
	ScienceDB DBConfig       `json:"science_db_read"`

	CSVCreatedQueue WorkerQueueConfig `json:"file_created_queue"`

	Rollbar RollbarConfig `json:"rollbar"`
}

type StatsConfig struct {
	Host   string `json:"host" validate:"nonzero"`
	Port   int    `json:"port" validate:"min=1,max=65535"`
	Prefix string `json:"prefix" validate:"nonzero"`
}

type DynamoDBConfig struct {
	Region string `json:"region" validate:"nonzero"`

	ConnTimeout    jsonconf.Duration `json:"conn_timeout" validate:"duration_min=1ms"`
	RequestTimeout jsonconf.Duration `json:"request_timeout" validate:"duration_min=1ms"`
	MaxIdleConns   int               `json:"max_idle_conns" validate:"min=1"`
}

type S3Config struct {
	Region          string `json:"region" validate:"nonzero"`
	BucketName      string `json:"bucket_name" validate:"nonzero"`
	AccessKeyID     string `json:"access_key_id" validate:"nonzero"`
	SecretAccessKey string `json:"secret_access_key" validate:"nonzero"`
}

type RollbarConfig struct {
	// Token is optional
	Token       string `json:"token"`
	Environment string `json:"environment" validate:"nonzero"`
}

type DBConfig struct {
	Host string `json:"host" validate:"nonzero"`
	Port int    `json:"port" validate:"min=1,max=65535"`

	Name       string `json:"dbname" validate:"nonzero"`
	User       string `json:"user" validate:"nonzero"`
	Password   string `json:"password" validate:"nonzero"`
	SSLEnabled bool   `json:"ssl_enabled"`

	MaxOpenConns       int               `json:"max_open_connections" validate:"min=1"`
	MaxIdleConns       int               `json:"max_idle_connections" validate:"min=1"`
	ConnQueueSize      int               `json:"conn_queue_size" validate:"min=0"`
	ConnAcquireTimeout jsonconf.Duration `json:"conn_acquire_timeout" validate:"duration_min=1ms"`
	RequestTimeout     jsonconf.Duration `json:"request_timeout" validate:"duration_min=1ms"`
	MaxConnAge         jsonconf.Duration `json:"max_conn_age" validate:"duration_min=1ms"`

	StatsPrefix string `json:"stats_prefix" validate:"nonzero"`
	LogQueries  bool   `json:"log_queries"`
}

type WorkerQueueConfig struct {
	Region    string `json:"region" validate:"nonzero"`
	QueueName string `json:"queue_name" validate:"nonzero"`
}
