package dbplus

import (
	"time"

	"code.justin.tv/chat/db"
)

func NewManager(db db.DB, logger *DbLogger) *DbManager {
	return &DbManager{
		db:     db,
		logger: logger,
	}
}

type DbManager struct {
	db     db.DB
	logger *DbLogger
}

func (m *DbManager) Manage(interval time.Duration) {
	ticker := time.Tick(interval)
	for {
		select {
		case <-ticker:
			m.logger.logDBState(m.db.Info())
		}
	}
}
