package gojiplus

import "net/http"

const (
	// UnknownErrorString should be returned to the user as a fallback if a
	// more descriptive error string cannot be given.
	UnknownErrorString = "Unknown Error"

	// StatusUnprocessableEntity is temporary until "net/http" exports this.
	StatusUnprocessableEntity = 422
)

var toString = map[int]string{
	http.StatusBadRequest:          "Bad Request",
	http.StatusUnauthorized:        "Unauthorized",
	http.StatusForbidden:           "Forbidden",
	http.StatusNotFound:            "Not Found",
	http.StatusConflict:            "Conflict",
	StatusUnprocessableEntity:      "Unprocessable",
	http.StatusInternalServerError: "Internal Server Error",
	http.StatusServiceUnavailable:  "Service Unavailable",
}

// StatusString returns a human-readable string for a status code.
func StatusString(status int) string {
	str, ok := toString[status]
	if !ok {
		return UnknownErrorString
	}
	return str
}

// IsServerError returns true if a status code indicates a server error.
// Useful for logging only server errors and ignoring client errors.
func IsServerError(status int) bool {
	return status >= 500
}
