package gojiplus

import (
	"encoding/json"
	"net"
	"net/http"
)

// GetIPFromRequest fetches the IP of the request.
func GetIPFromRequest(r *http.Request) string {
	if ip := fetchHeader(r, "X-Forwarded-For"); ip != "" {
		return ip
	}
	ip, _, _ := net.SplitHostPort(r.RemoteAddr)
	return ip
}

// ParseJSONFromRequest parses the request body for JSON and unmarshals to <t>.
func ParseJSONFromRequest(r *http.Request, t interface{}) error {
	return json.NewDecoder(r.Body).Decode(&t)
}
