package jsonconf

import (
	"encoding/json"
	"io"
	"os"
)

func ReadFile(conf interface{}, filename string) error {
	f, err := os.Open(filename)
	if err != nil {
		return err
	}
	return Read(conf, f)
}

func Read(conf interface{}, reader io.Reader) error {
	d := json.NewDecoder(reader)
	err := d.Decode(conf)
	if err != nil {
		return err
	}
	return jsonValidator.Validate(conf)
}
