package jsonconf

import (
	"encoding/json"
	"errors"
	"strconv"
	"time"
)

type Duration time.Duration

var _ json.Unmarshaler = (*Duration)(nil)

func (d *Duration) UnmarshalJSON(b []byte) (err error) {
	var dur time.Duration
	var millis int
	if dur, err = parseDuration(b); err == nil {
		*d = Duration(dur)
	} else {
		// TODO: remove this after new config and code are deployed.
		// If the above fails, we assume the input to be in an int
		// describing milliseconds
		if millis, err = strconv.Atoi(string(b)); err == nil {
			*d = Duration(millis) * Duration(time.Millisecond)
		}
	}
	return err
}

func parseDuration(b []byte) (time.Duration, error) {
	if len(b) < 3 || b[0] != '"' || b[len(b)-1] != '"' {
		return 0, errors.New("invalid Duration format")
	}
	return time.ParseDuration(string(b[1 : len(b)-1]))
}
