package util

import (
	"math"
	"unicode/utf8"
)

// Shannon entropy.
func Entropy(str string) float64 {
	m := map[rune]float64{}
	for _, c := range str {
		m[c]++
	}
	n := 0.0
	for _, count := range m {
		n += count * math.Log2(count)
	}
	length := float64(utf8.RuneCountInString(str))
	return math.Log2(length) - n/length
}
