// Code generated by protoc-gen-go.
// source: topodata.proto
// DO NOT EDIT!

/*
Package topodata is a generated protocol buffer package.

It is generated from these files:
	topodata.proto

It has these top-level messages:
	KeyRange
	TabletAlias
	Tablet
	Shard
	Keyspace
	ShardReplication
	EndPoint
	EndPoints
	SrvShard
	ShardReference
	SrvKeyspace
*/
package topodata

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
const _ = proto.ProtoPackageIsVersion1

// KeyspaceIdType describes the type of the sharding key for a
// range-based sharded keyspace.
type KeyspaceIdType int32

const (
	// UNSET is the default value, when range-based sharding is not used.
	KeyspaceIdType_UNSET KeyspaceIdType = 0
	// UINT64 is when uint64 value is used.
	// This is represented as 'unsigned bigint' in mysql
	KeyspaceIdType_UINT64 KeyspaceIdType = 1
	// BYTES is when an array of bytes is used.
	// This is represented as 'varbinary' in mysql
	KeyspaceIdType_BYTES KeyspaceIdType = 2
)

var KeyspaceIdType_name = map[int32]string{
	0: "UNSET",
	1: "UINT64",
	2: "BYTES",
}
var KeyspaceIdType_value = map[string]int32{
	"UNSET":  0,
	"UINT64": 1,
	"BYTES":  2,
}

func (x KeyspaceIdType) String() string {
	return proto.EnumName(KeyspaceIdType_name, int32(x))
}
func (KeyspaceIdType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// TabletType represents the type of a given tablet.
type TabletType int32

const (
	TabletType_UNKNOWN      TabletType = 0
	TabletType_MASTER       TabletType = 1
	TabletType_REPLICA      TabletType = 2
	TabletType_RDONLY       TabletType = 3
	TabletType_BATCH        TabletType = 3
	TabletType_SPARE        TabletType = 4
	TabletType_EXPERIMENTAL TabletType = 5
	TabletType_BACKUP       TabletType = 6
	TabletType_RESTORE      TabletType = 7
	TabletType_WORKER       TabletType = 8
)

var TabletType_name = map[int32]string{
	0: "UNKNOWN",
	1: "MASTER",
	2: "REPLICA",
	3: "RDONLY",
	// Duplicate value: 3: "BATCH",
	4: "SPARE",
	5: "EXPERIMENTAL",
	6: "BACKUP",
	7: "RESTORE",
	8: "WORKER",
}
var TabletType_value = map[string]int32{
	"UNKNOWN":      0,
	"MASTER":       1,
	"REPLICA":      2,
	"RDONLY":       3,
	"BATCH":        3,
	"SPARE":        4,
	"EXPERIMENTAL": 5,
	"BACKUP":       6,
	"RESTORE":      7,
	"WORKER":       8,
}

func (x TabletType) String() string {
	return proto.EnumName(TabletType_name, int32(x))
}
func (TabletType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// KeyRange describes a range of sharding keys, when range-based
// sharding is used.
type KeyRange struct {
	Start []byte `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	End   []byte `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (m *KeyRange) Reset()                    { *m = KeyRange{} }
func (m *KeyRange) String() string            { return proto.CompactTextString(m) }
func (*KeyRange) ProtoMessage()               {}
func (*KeyRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// TabletAlias is a globally unique tablet identifier.
type TabletAlias struct {
	// cell is the cell (or datacenter) the tablet is in
	Cell string `protobuf:"bytes,1,opt,name=cell" json:"cell,omitempty"`
	// uid is a unique id for this tablet within the shard
	// (this is the MySQL server id as well).
	Uid uint32 `protobuf:"varint,2,opt,name=uid" json:"uid,omitempty"`
}

func (m *TabletAlias) Reset()                    { *m = TabletAlias{} }
func (m *TabletAlias) String() string            { return proto.CompactTextString(m) }
func (*TabletAlias) ProtoMessage()               {}
func (*TabletAlias) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Tablet represents information about a running instance of vttablet.
type Tablet struct {
	// alias is the unique name of the tablet.
	Alias *TabletAlias `protobuf:"bytes,1,opt,name=alias" json:"alias,omitempty"`
	// Fully qualified domain name of the host.
	Hostname string `protobuf:"bytes,2,opt,name=hostname" json:"hostname,omitempty"`
	// IP address, stored as a string.
	Ip string `protobuf:"bytes,3,opt,name=ip" json:"ip,omitempty"`
	// Map of named ports. Normally this should include vt, grpc, and mysql.
	PortMap map[string]int32 `protobuf:"bytes,4,rep,name=port_map,json=portMap" json:"port_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	// Keyspace name.
	Keyspace string `protobuf:"bytes,5,opt,name=keyspace" json:"keyspace,omitempty"`
	// Shard name. If range based sharding is used, it should match
	// key_range.
	Shard string `protobuf:"bytes,6,opt,name=shard" json:"shard,omitempty"`
	// If range based sharding is used, range for the tablet's shard.
	KeyRange *KeyRange `protobuf:"bytes,7,opt,name=key_range,json=keyRange" json:"key_range,omitempty"`
	// type is the current type of the tablet.
	Type TabletType `protobuf:"varint,8,opt,name=type,enum=topodata.TabletType" json:"type,omitempty"`
	// It this is set, it is used as the database name instead of the
	// normal "vt_" + keyspace.
	DbNameOverride string `protobuf:"bytes,9,opt,name=db_name_override,json=dbNameOverride" json:"db_name_override,omitempty"`
	// tablet tags
	Tags map[string]string `protobuf:"bytes,10,rep,name=tags" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// tablet health information
	HealthMap map[string]string `protobuf:"bytes,11,rep,name=health_map,json=healthMap" json:"health_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Tablet) Reset()                    { *m = Tablet{} }
func (m *Tablet) String() string            { return proto.CompactTextString(m) }
func (*Tablet) ProtoMessage()               {}
func (*Tablet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Tablet) GetAlias() *TabletAlias {
	if m != nil {
		return m.Alias
	}
	return nil
}

func (m *Tablet) GetPortMap() map[string]int32 {
	if m != nil {
		return m.PortMap
	}
	return nil
}

func (m *Tablet) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *Tablet) GetTags() map[string]string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *Tablet) GetHealthMap() map[string]string {
	if m != nil {
		return m.HealthMap
	}
	return nil
}

// A Shard contains data about a subset of the data whithin a keyspace.
type Shard struct {
	// master_alias is the tablet alias of the master for the shard.
	// If it is unset, then there is no master in this shard yet.
	MasterAlias *TabletAlias `protobuf:"bytes,1,opt,name=master_alias,json=masterAlias" json:"master_alias,omitempty"`
	// key_range is the KeyRange for this shard. It can be unset if:
	// - we are not using range-based sharding in this shard.
	// - the shard covers the entire keyrange.
	// This must match the shard name based on our other conventions, but
	// helpful to have it decomposed here.
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange" json:"key_range,omitempty"`
	// served_types has at most one entry per TabletType
	ServedTypes []*Shard_ServedType `protobuf:"bytes,3,rep,name=served_types,json=servedTypes" json:"served_types,omitempty"`
	// SourceShards is the list of shards we're replicating from,
	// using filtered replication.
	SourceShards []*Shard_SourceShard `protobuf:"bytes,4,rep,name=source_shards,json=sourceShards" json:"source_shards,omitempty"`
	// Cells is the list of cells that contain tablets for this shard.
	Cells []string `protobuf:"bytes,5,rep,name=cells" json:"cells,omitempty"`
	// tablet_controls has at most one entry per TabletType
	TabletControls []*Shard_TabletControl `protobuf:"bytes,6,rep,name=tablet_controls,json=tabletControls" json:"tablet_controls,omitempty"`
}

func (m *Shard) Reset()                    { *m = Shard{} }
func (m *Shard) String() string            { return proto.CompactTextString(m) }
func (*Shard) ProtoMessage()               {}
func (*Shard) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Shard) GetMasterAlias() *TabletAlias {
	if m != nil {
		return m.MasterAlias
	}
	return nil
}

func (m *Shard) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

func (m *Shard) GetServedTypes() []*Shard_ServedType {
	if m != nil {
		return m.ServedTypes
	}
	return nil
}

func (m *Shard) GetSourceShards() []*Shard_SourceShard {
	if m != nil {
		return m.SourceShards
	}
	return nil
}

func (m *Shard) GetTabletControls() []*Shard_TabletControl {
	if m != nil {
		return m.TabletControls
	}
	return nil
}

// ServedType is an entry in the served_types
type Shard_ServedType struct {
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	Cells      []string   `protobuf:"bytes,2,rep,name=cells" json:"cells,omitempty"`
}

func (m *Shard_ServedType) Reset()                    { *m = Shard_ServedType{} }
func (m *Shard_ServedType) String() string            { return proto.CompactTextString(m) }
func (*Shard_ServedType) ProtoMessage()               {}
func (*Shard_ServedType) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 0} }

// SourceShard represents a data source for filtered replication
// accross shards. When this is used in a destination shard, the master
// of that shard will run filtered replication.
type Shard_SourceShard struct {
	// Uid is the unique ID for this SourceShard object.
	Uid uint32 `protobuf:"varint,1,opt,name=uid" json:"uid,omitempty"`
	// the source keyspace
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
	// the source shard
	Shard string `protobuf:"bytes,3,opt,name=shard" json:"shard,omitempty"`
	// the source shard keyrange
	KeyRange *KeyRange `protobuf:"bytes,4,opt,name=key_range,json=keyRange" json:"key_range,omitempty"`
	// the source table list to replicate
	Tables []string `protobuf:"bytes,5,rep,name=tables" json:"tables,omitempty"`
}

func (m *Shard_SourceShard) Reset()                    { *m = Shard_SourceShard{} }
func (m *Shard_SourceShard) String() string            { return proto.CompactTextString(m) }
func (*Shard_SourceShard) ProtoMessage()               {}
func (*Shard_SourceShard) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 1} }

func (m *Shard_SourceShard) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

// TabletControl controls tablet's behavior
type Shard_TabletControl struct {
	// which tablet type is affected
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	Cells      []string   `protobuf:"bytes,2,rep,name=cells" json:"cells,omitempty"`
	// what to do
	DisableQueryService bool     `protobuf:"varint,3,opt,name=disable_query_service,json=disableQueryService" json:"disable_query_service,omitempty"`
	BlacklistedTables   []string `protobuf:"bytes,4,rep,name=blacklisted_tables,json=blacklistedTables" json:"blacklisted_tables,omitempty"`
}

func (m *Shard_TabletControl) Reset()                    { *m = Shard_TabletControl{} }
func (m *Shard_TabletControl) String() string            { return proto.CompactTextString(m) }
func (*Shard_TabletControl) ProtoMessage()               {}
func (*Shard_TabletControl) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 2} }

// A Keyspace contains data about a keyspace.
type Keyspace struct {
	// name of the column used for sharding
	// empty if the keyspace is not sharded
	ShardingColumnName string `protobuf:"bytes,1,opt,name=sharding_column_name,json=shardingColumnName" json:"sharding_column_name,omitempty"`
	// type of the column used for sharding
	// UNSET if the keyspace is not sharded
	ShardingColumnType KeyspaceIdType `protobuf:"varint,2,opt,name=sharding_column_type,json=shardingColumnType,enum=topodata.KeyspaceIdType" json:"sharding_column_type,omitempty"`
	// SplitShardCount stores the number of jobs to run to be sure to
	// always have at most one job per shard (used during resharding).
	SplitShardCount int32 `protobuf:"varint,3,opt,name=split_shard_count,json=splitShardCount" json:"split_shard_count,omitempty"`
	// ServedFrom will redirect the appropriate traffic to
	// another keyspace.
	ServedFroms []*Keyspace_ServedFrom `protobuf:"bytes,4,rep,name=served_froms,json=servedFroms" json:"served_froms,omitempty"`
}

func (m *Keyspace) Reset()                    { *m = Keyspace{} }
func (m *Keyspace) String() string            { return proto.CompactTextString(m) }
func (*Keyspace) ProtoMessage()               {}
func (*Keyspace) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *Keyspace) GetServedFroms() []*Keyspace_ServedFrom {
	if m != nil {
		return m.ServedFroms
	}
	return nil
}

// ServedFrom indicates a relationship between a TabletType and the
// keyspace name that's serving it.
type Keyspace_ServedFrom struct {
	// the tablet type (key for the map)
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// the cells to limit this to
	Cells []string `protobuf:"bytes,2,rep,name=cells" json:"cells,omitempty"`
	// the keyspace name that's serving it
	Keyspace string `protobuf:"bytes,3,opt,name=keyspace" json:"keyspace,omitempty"`
}

func (m *Keyspace_ServedFrom) Reset()                    { *m = Keyspace_ServedFrom{} }
func (m *Keyspace_ServedFrom) String() string            { return proto.CompactTextString(m) }
func (*Keyspace_ServedFrom) ProtoMessage()               {}
func (*Keyspace_ServedFrom) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4, 0} }

// ShardReplication describes the MySQL replication relationships
// whithin a cell.
type ShardReplication struct {
	// Note there can be only one Node in this array
	// for a given tablet.
	Nodes []*ShardReplication_Node `protobuf:"bytes,1,rep,name=nodes" json:"nodes,omitempty"`
}

func (m *ShardReplication) Reset()                    { *m = ShardReplication{} }
func (m *ShardReplication) String() string            { return proto.CompactTextString(m) }
func (*ShardReplication) ProtoMessage()               {}
func (*ShardReplication) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ShardReplication) GetNodes() []*ShardReplication_Node {
	if m != nil {
		return m.Nodes
	}
	return nil
}

// Node describes a tablet instance within the cell
type ShardReplication_Node struct {
	TabletAlias *TabletAlias `protobuf:"bytes,1,opt,name=tablet_alias,json=tabletAlias" json:"tablet_alias,omitempty"`
}

func (m *ShardReplication_Node) Reset()                    { *m = ShardReplication_Node{} }
func (m *ShardReplication_Node) String() string            { return proto.CompactTextString(m) }
func (*ShardReplication_Node) ProtoMessage()               {}
func (*ShardReplication_Node) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5, 0} }

func (m *ShardReplication_Node) GetTabletAlias() *TabletAlias {
	if m != nil {
		return m.TabletAlias
	}
	return nil
}

// EndPoint corresponds to a single tablet.
type EndPoint struct {
	// The uid of the tablet.
	Uid uint32 `protobuf:"varint,1,opt,name=uid" json:"uid,omitempty"`
	// The host the tablet is running on (FQDN).
	Host string `protobuf:"bytes,2,opt,name=host" json:"host,omitempty"`
	// The ports opened for service.
	PortMap map[string]int32 `protobuf:"bytes,3,rep,name=port_map,json=portMap" json:"port_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	// The health entries.
	HealthMap map[string]string `protobuf:"bytes,4,rep,name=health_map,json=healthMap" json:"health_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *EndPoint) Reset()                    { *m = EndPoint{} }
func (m *EndPoint) String() string            { return proto.CompactTextString(m) }
func (*EndPoint) ProtoMessage()               {}
func (*EndPoint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *EndPoint) GetPortMap() map[string]int32 {
	if m != nil {
		return m.PortMap
	}
	return nil
}

func (m *EndPoint) GetHealthMap() map[string]string {
	if m != nil {
		return m.HealthMap
	}
	return nil
}

// EndPoints corresponds to a list of tablets.
type EndPoints struct {
	Entries []*EndPoint `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
}

func (m *EndPoints) Reset()                    { *m = EndPoints{} }
func (m *EndPoints) String() string            { return proto.CompactTextString(m) }
func (*EndPoints) ProtoMessage()               {}
func (*EndPoints) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *EndPoints) GetEntries() []*EndPoint {
	if m != nil {
		return m.Entries
	}
	return nil
}

// SrvShard is a rollup node for the shard itself.
type SrvShard struct {
	// Copied from Shard.
	Name     string    `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange" json:"key_range,omitempty"`
	// The cell that master tablet resides in.
	MasterCell string `protobuf:"bytes,3,opt,name=master_cell,json=masterCell" json:"master_cell,omitempty"`
}

func (m *SrvShard) Reset()                    { *m = SrvShard{} }
func (m *SrvShard) String() string            { return proto.CompactTextString(m) }
func (*SrvShard) ProtoMessage()               {}
func (*SrvShard) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *SrvShard) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

// ShardReference is used as a pointer from a SrvKeyspace to a SrvShard
type ShardReference struct {
	// Copied from Shard.
	Name     string    `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	KeyRange *KeyRange `protobuf:"bytes,2,opt,name=key_range,json=keyRange" json:"key_range,omitempty"`
}

func (m *ShardReference) Reset()                    { *m = ShardReference{} }
func (m *ShardReference) String() string            { return proto.CompactTextString(m) }
func (*ShardReference) ProtoMessage()               {}
func (*ShardReference) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *ShardReference) GetKeyRange() *KeyRange {
	if m != nil {
		return m.KeyRange
	}
	return nil
}

// SrvKeyspace is a rollup node for the keyspace itself.
type SrvKeyspace struct {
	// The partitions this keyspace is serving, per tablet type.
	Partitions []*SrvKeyspace_KeyspacePartition `protobuf:"bytes,1,rep,name=partitions" json:"partitions,omitempty"`
	// copied from Keyspace
	ShardingColumnName string                    `protobuf:"bytes,2,opt,name=sharding_column_name,json=shardingColumnName" json:"sharding_column_name,omitempty"`
	ShardingColumnType KeyspaceIdType            `protobuf:"varint,3,opt,name=sharding_column_type,json=shardingColumnType,enum=topodata.KeyspaceIdType" json:"sharding_column_type,omitempty"`
	ServedFrom         []*SrvKeyspace_ServedFrom `protobuf:"bytes,4,rep,name=served_from,json=servedFrom" json:"served_from,omitempty"`
	SplitShardCount    int32                     `protobuf:"varint,5,opt,name=split_shard_count,json=splitShardCount" json:"split_shard_count,omitempty"`
}

func (m *SrvKeyspace) Reset()                    { *m = SrvKeyspace{} }
func (m *SrvKeyspace) String() string            { return proto.CompactTextString(m) }
func (*SrvKeyspace) ProtoMessage()               {}
func (*SrvKeyspace) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *SrvKeyspace) GetPartitions() []*SrvKeyspace_KeyspacePartition {
	if m != nil {
		return m.Partitions
	}
	return nil
}

func (m *SrvKeyspace) GetServedFrom() []*SrvKeyspace_ServedFrom {
	if m != nil {
		return m.ServedFrom
	}
	return nil
}

type SrvKeyspace_KeyspacePartition struct {
	// The type this partition applies to.
	ServedType TabletType `protobuf:"varint,1,opt,name=served_type,json=servedType,enum=topodata.TabletType" json:"served_type,omitempty"`
	// List of non-overlapping continuous shards sorted by range.
	ShardReferences []*ShardReference `protobuf:"bytes,2,rep,name=shard_references,json=shardReferences" json:"shard_references,omitempty"`
}

func (m *SrvKeyspace_KeyspacePartition) Reset()         { *m = SrvKeyspace_KeyspacePartition{} }
func (m *SrvKeyspace_KeyspacePartition) String() string { return proto.CompactTextString(m) }
func (*SrvKeyspace_KeyspacePartition) ProtoMessage()    {}
func (*SrvKeyspace_KeyspacePartition) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{10, 0}
}

func (m *SrvKeyspace_KeyspacePartition) GetShardReferences() []*ShardReference {
	if m != nil {
		return m.ShardReferences
	}
	return nil
}

// ServedFrom indicates a relationship between a TabletType and the
// keyspace name that's serving it.
type SrvKeyspace_ServedFrom struct {
	// the tablet type
	TabletType TabletType `protobuf:"varint,1,opt,name=tablet_type,json=tabletType,enum=topodata.TabletType" json:"tablet_type,omitempty"`
	// the keyspace name that's serving it
	Keyspace string `protobuf:"bytes,2,opt,name=keyspace" json:"keyspace,omitempty"`
}

func (m *SrvKeyspace_ServedFrom) Reset()                    { *m = SrvKeyspace_ServedFrom{} }
func (m *SrvKeyspace_ServedFrom) String() string            { return proto.CompactTextString(m) }
func (*SrvKeyspace_ServedFrom) ProtoMessage()               {}
func (*SrvKeyspace_ServedFrom) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10, 1} }

func init() {
	proto.RegisterType((*KeyRange)(nil), "topodata.KeyRange")
	proto.RegisterType((*TabletAlias)(nil), "topodata.TabletAlias")
	proto.RegisterType((*Tablet)(nil), "topodata.Tablet")
	proto.RegisterType((*Shard)(nil), "topodata.Shard")
	proto.RegisterType((*Shard_ServedType)(nil), "topodata.Shard.ServedType")
	proto.RegisterType((*Shard_SourceShard)(nil), "topodata.Shard.SourceShard")
	proto.RegisterType((*Shard_TabletControl)(nil), "topodata.Shard.TabletControl")
	proto.RegisterType((*Keyspace)(nil), "topodata.Keyspace")
	proto.RegisterType((*Keyspace_ServedFrom)(nil), "topodata.Keyspace.ServedFrom")
	proto.RegisterType((*ShardReplication)(nil), "topodata.ShardReplication")
	proto.RegisterType((*ShardReplication_Node)(nil), "topodata.ShardReplication.Node")
	proto.RegisterType((*EndPoint)(nil), "topodata.EndPoint")
	proto.RegisterType((*EndPoints)(nil), "topodata.EndPoints")
	proto.RegisterType((*SrvShard)(nil), "topodata.SrvShard")
	proto.RegisterType((*ShardReference)(nil), "topodata.ShardReference")
	proto.RegisterType((*SrvKeyspace)(nil), "topodata.SrvKeyspace")
	proto.RegisterType((*SrvKeyspace_KeyspacePartition)(nil), "topodata.SrvKeyspace.KeyspacePartition")
	proto.RegisterType((*SrvKeyspace_ServedFrom)(nil), "topodata.SrvKeyspace.ServedFrom")
	proto.RegisterEnum("topodata.KeyspaceIdType", KeyspaceIdType_name, KeyspaceIdType_value)
	proto.RegisterEnum("topodata.TabletType", TabletType_name, TabletType_value)
}

var fileDescriptor0 = []byte{
	// 1196 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xb4, 0x57, 0xdd, 0x72, 0x22, 0x45,
	0x14, 0x96, 0xe1, 0x27, 0x70, 0x60, 0xd9, 0xd9, 0x36, 0x6b, 0x4d, 0x8d, 0x65, 0x6d, 0xe4, 0xc6,
	0xad, 0xa8, 0x68, 0x65, 0xfd, 0x89, 0x29, 0xb5, 0x42, 0x90, 0x75, 0x63, 0x12, 0x82, 0x0d, 0xa9,
	0x35, 0x57, 0x53, 0x03, 0xf4, 0x26, 0x53, 0x0b, 0x33, 0xe3, 0x74, 0x43, 0x15, 0xcf, 0xb0, 0x17,
	0xde, 0xfb, 0x04, 0x3e, 0x81, 0xb7, 0x3e, 0x91, 0x97, 0xde, 0xdb, 0x7d, 0x7a, 0x06, 0x06, 0x48,
	0x62, 0xa2, 0xf1, 0x8a, 0x73, 0xfa, 0xfc, 0xf4, 0xf9, 0xfd, 0x7a, 0x80, 0xaa, 0x08, 0xc2, 0x60,
	0xe8, 0x0a, 0xb7, 0x1e, 0x46, 0x81, 0x08, 0x48, 0x31, 0xe1, 0x6b, 0x3b, 0x50, 0x3c, 0x62, 0x33,
	0xea, 0xfa, 0x17, 0x8c, 0x6c, 0x42, 0x9e, 0x0b, 0x37, 0x12, 0x56, 0x66, 0x2b, 0xf3, 0xb4, 0x42,
	0x35, 0x43, 0x4c, 0xc8, 0x32, 0x7f, 0x68, 0x19, 0x78, 0xa6, 0xc8, 0xda, 0x33, 0x28, 0xf7, 0xdc,
	0xfe, 0x88, 0x89, 0xc6, 0xc8, 0x73, 0x39, 0x21, 0x90, 0x1b, 0xb0, 0xd1, 0x08, 0xad, 0x4a, 0x14,
	0x69, 0x65, 0x34, 0xf1, 0xb4, 0xd1, 0x03, 0xaa, 0xc8, 0xda, 0x5f, 0x39, 0x28, 0x68, 0x2b, 0xf2,
	0x21, 0xe4, 0x5d, 0x65, 0x89, 0x16, 0xe5, 0x9d, 0xc7, 0xf5, 0x79, 0x74, 0x29, 0xb7, 0x54, 0xeb,
	0x10, 0x1b, 0x8a, 0x97, 0x01, 0x17, 0xbe, 0x3b, 0x66, 0xe8, 0xae, 0x44, 0xe7, 0x3c, 0xa9, 0x82,
	0xe1, 0x85, 0x56, 0x16, 0x4f, 0x25, 0x45, 0x76, 0xa1, 0x18, 0x06, 0x91, 0x70, 0xc6, 0x6e, 0x68,
	0xe5, 0xb6, 0xb2, 0xd2, 0xf7, 0x7b, 0xab, 0xbe, 0xeb, 0x1d, 0xa9, 0x70, 0xe2, 0x86, 0x2d, 0x5f,
	0x44, 0x33, 0xba, 0x11, 0x6a, 0x4e, 0xdd, 0xf2, 0x9a, 0xcd, 0x78, 0xe8, 0x0e, 0x98, 0x95, 0xd7,
	0xb7, 0x24, 0x3c, 0x96, 0xe5, 0xd2, 0x8d, 0x86, 0x56, 0x01, 0x05, 0x9a, 0x21, 0x9f, 0x40, 0x49,
	0x6a, 0x38, 0x91, 0xaa, 0x9c, 0xb5, 0x81, 0x89, 0x90, 0xc5, 0x65, 0x49, 0x4d, 0xd1, 0x8d, 0xae,
	0xee, 0x53, 0xc8, 0x89, 0x59, 0xc8, 0xac, 0xa2, 0xd4, 0xad, 0xee, 0x6c, 0xae, 0x06, 0xd6, 0x93,
	0x32, 0x8a, 0x1a, 0x52, 0xd3, 0x1c, 0xf6, 0x1d, 0x95, 0xa1, 0x13, 0x4c, 0x59, 0x14, 0x79, 0x43,
	0x66, 0x95, 0xf0, 0xee, 0xea, 0xb0, 0xdf, 0x96, 0xc7, 0xa7, 0xf1, 0x29, 0xa9, 0x4b, 0x9f, 0xee,
	0x05, 0xb7, 0x00, 0x93, 0xb5, 0xd7, 0x92, 0xed, 0x49, 0xa1, 0xce, 0x14, 0xf5, 0xc8, 0xb7, 0x00,
	0x97, 0xcc, 0x1d, 0x89, 0x4b, 0x2c, 0x51, 0x19, 0xad, 0x9e, 0xac, 0x59, 0xbd, 0x40, 0x95, 0x79,
	0x91, 0x4a, 0x97, 0x09, 0x6f, 0xef, 0x41, 0x25, 0x5d, 0x3f, 0xd5, 0x66, 0x99, 0x5f, 0xdc, 0x79,
	0x45, 0xaa, 0x62, 0x4d, 0xdd, 0xd1, 0x44, 0xf7, 0x2a, 0x4f, 0x35, 0xb3, 0x67, 0xec, 0x66, 0xec,
	0x2f, 0xa1, 0x34, 0x0f, 0xe7, 0x9f, 0x0c, 0x4b, 0x69, 0xc3, 0xaf, 0xa1, 0xba, 0x1c, 0xd1, 0x5d,
	0xac, 0x6b, 0x6f, 0x0a, 0x90, 0xef, 0x62, 0xc7, 0x76, 0xa1, 0x32, 0x76, 0xb9, 0x60, 0x91, 0x73,
	0x8b, 0xe9, 0x2b, 0x6b, 0x55, 0x3d, 0xe1, 0x4b, 0xbd, 0x36, 0x6e, 0xd1, 0xeb, 0x6f, 0xa0, 0xc2,
	0x59, 0x34, 0x65, 0x43, 0x47, 0x35, 0x94, 0xcb, 0x11, 0x5d, 0xe9, 0x0f, 0x46, 0x54, 0xef, 0xa2,
	0x0e, 0x76, 0xbe, 0xcc, 0xe7, 0x34, 0x27, 0xfb, 0xf0, 0x80, 0x07, 0x93, 0x68, 0xc0, 0x1c, 0x9c,
	0x35, 0x1e, 0x0f, 0xf3, 0xbb, 0x6b, 0xf6, 0xa8, 0x84, 0x34, 0xad, 0xf0, 0x05, 0xc3, 0x55, 0x3d,
	0xd4, 0x1e, 0x72, 0x39, 0xcc, 0x59, 0x55, 0x0f, 0x64, 0xc8, 0x73, 0x78, 0x28, 0x30, 0x47, 0x67,
	0x10, 0xc8, 0x42, 0x06, 0x52, 0x5e, 0x58, 0x5d, 0x13, 0xed, 0x59, 0x97, 0xa2, 0xa9, 0xb5, 0x68,
	0x55, 0xa4, 0x59, 0x6e, 0x9f, 0x03, 0x2c, 0x42, 0x27, 0x9f, 0x43, 0x39, 0xf6, 0x8a, 0xf3, 0x9d,
	0xb9, 0x61, 0xbe, 0x41, 0xcc, 0xe9, 0x45, 0x88, 0x46, 0x2a, 0x44, 0xfb, 0xd7, 0x0c, 0x94, 0x53,
	0x69, 0x25, 0x40, 0x92, 0x99, 0x03, 0xc9, 0xd2, 0xaa, 0x1a, 0xd7, 0xad, 0x6a, 0xf6, 0xda, 0x55,
	0xcd, 0xdd, 0xa2, 0x7d, 0xef, 0x40, 0x01, 0x03, 0x4d, 0xca, 0x17, 0x73, 0xf6, 0x1f, 0x19, 0x78,
	0xb0, 0x54, 0x99, 0x7b, 0xcd, 0x9d, 0xec, 0xc0, 0xe3, 0xa1, 0xc7, 0x95, 0x96, 0xf3, 0xf3, 0x84,
	0x45, 0x33, 0x47, 0xcd, 0x84, 0x27, 0xd3, 0x54, 0xd9, 0x14, 0xe9, 0xdb, 0xb1, 0xf0, 0x47, 0x25,
	0xeb, 0x6a, 0x11, 0xf9, 0x18, 0x48, 0x7f, 0xe4, 0x0e, 0x5e, 0x8f, 0x3c, 0x39, 0xae, 0x72, 0xdc,
	0x74, 0xd8, 0x39, 0x74, 0xfb, 0x28, 0x25, 0xc1, 0x40, 0x78, 0xed, 0x4f, 0x03, 0xf1, 0x5e, 0x57,
	0xeb, 0x53, 0xd8, 0xc4, 0x02, 0x79, 0xfe, 0x85, 0x1c, 0x88, 0xd1, 0x64, 0xec, 0x23, 0xe8, 0xc4,
	0x7b, 0x45, 0x12, 0x59, 0x13, 0x45, 0x0a, 0x77, 0xc8, 0x0f, 0xeb, 0x16, 0x98, 0xb7, 0x81, 0x79,
	0x5b, 0x4b, 0x45, 0xc5, 0x3b, 0x0e, 0xf5, 0x74, 0xaf, 0xf8, 0xc2, 0x1a, 0x6c, 0xc3, 0x23, 0x1e,
	0x8e, 0x3c, 0xa1, 0x67, 0x5c, 0xba, 0x9b, 0xf8, 0x02, 0x33, 0xcd, 0xd3, 0x87, 0x28, 0xc0, 0x01,
	0x68, 0xaa, 0x63, 0xb9, 0x10, 0xc9, 0x3e, 0xbd, 0x8a, 0x82, 0x31, 0x5f, 0x07, 0xf7, 0xe4, 0xbe,
	0x78, 0xa5, 0x9e, 0x4b, 0xad, 0x64, 0xa5, 0x14, 0xcd, 0xed, 0x49, 0x32, 0xb2, 0x8a, 0xbd, 0xdf,
	0xb6, 0xa5, 0x07, 0x32, 0xbb, 0x3c, 0x90, 0xb5, 0x37, 0x19, 0x30, 0xf5, 0x7e, 0x32, 0x99, 0xd2,
	0xc0, 0x15, 0x5e, 0xe0, 0xcb, 0xdb, 0xf3, 0x7e, 0x30, 0x64, 0x0a, 0x81, 0x56, 0x00, 0x78, 0x55,
	0xb5, 0xde, 0x96, 0x7a, 0x54, 0x6b, 0xdb, 0xfb, 0x90, 0x53, 0xac, 0xc2, 0xb1, 0x38, 0xf8, 0xdb,
	0xe0, 0x98, 0x58, 0x30, 0xb5, 0xdf, 0x64, 0xf7, 0x5b, 0xfe, 0xb0, 0x13, 0x78, 0xbe, 0xb8, 0x62,
	0xb3, 0xe4, 0x43, 0xae, 0x9e, 0xd6, 0x78, 0xab, 0x90, 0x26, 0x7b, 0xa9, 0x27, 0x35, 0xbb, 0x1a,
	0x6e, 0xe2, 0xeb, 0x9a, 0x47, 0x75, 0x7f, 0xe9, 0xb5, 0xd1, 0x3d, 0x7b, 0xff, 0x0a, 0xeb, 0xff,
	0xe7, 0xbd, 0xf9, 0x6f, 0xcf, 0xc6, 0x57, 0x50, 0x4a, 0xe2, 0xe3, 0xe4, 0x23, 0xd8, 0x60, 0xd2,
	0x83, 0x37, 0x6f, 0x19, 0x59, 0xcf, 0x82, 0x26, 0x2a, 0xb5, 0x10, 0x8a, 0xdd, 0x68, 0xaa, 0xe1,
	0x4b, 0x96, 0x34, 0xb5, 0x52, 0x48, 0xdf, 0xfd, 0x35, 0x79, 0x02, 0xf1, 0x6b, 0xe4, 0xe0, 0x77,
	0x96, 0x9e, 0x31, 0xd0, 0x47, 0x4d, 0x79, 0x52, 0x3b, 0x83, 0x6a, 0x3c, 0x39, 0xaf, 0x58, 0xc4,
	0x7c, 0xb9, 0xda, 0xf7, 0x71, 0x6f, 0xed, 0xf7, 0x9c, 0xc4, 0xe2, 0x68, 0x3a, 0xc7, 0x8b, 0xef,
	0x01, 0x42, 0xf9, 0x45, 0xe8, 0xa9, 0xc9, 0x4c, 0x2a, 0xf1, 0x41, 0x6a, 0x78, 0x17, 0xaa, 0xf3,
	0x7d, 0xec, 0x24, 0xfa, 0x34, 0x65, 0x7a, 0x2d, 0xf0, 0x18, 0x77, 0x06, 0x9e, 0xec, 0xbf, 0x00,
	0x9e, 0x06, 0x94, 0x53, 0x60, 0x12, 0xcf, 0xe5, 0xd6, 0xd5, 0x79, 0xa4, 0xe0, 0x04, 0x16, 0x70,
	0x72, 0x35, 0x76, 0xe5, 0xaf, 0xc4, 0x2e, 0xfb, 0x97, 0x0c, 0x3c, 0x5a, 0x2b, 0x87, 0x42, 0xa0,
	0xd4, 0x17, 0xc2, 0xcd, 0x08, 0xb4, 0xf8, 0x34, 0x20, 0x4d, 0x30, 0xf5, 0x95, 0x51, 0xd2, 0x6a,
	0x0d, 0x46, 0xe5, 0x74, 0x0d, 0x96, 0x67, 0x41, 0x46, 0xb4, 0xc4, 0x73, 0xdb, 0xb9, 0x0f, 0x2c,
	0xbc, 0xe1, 0x19, 0xde, 0xde, 0x81, 0xea, 0x72, 0x1f, 0x48, 0x09, 0xf2, 0x67, 0xed, 0x6e, 0xab,
	0x67, 0xbe, 0x45, 0x00, 0x0a, 0x67, 0x87, 0xed, 0xde, 0x17, 0x9f, 0x99, 0x19, 0x75, 0x7c, 0x70,
	0xde, 0x6b, 0x75, 0x4d, 0x63, 0x5b, 0x96, 0x09, 0x16, 0x57, 0x91, 0x32, 0x6c, 0x9c, 0xb5, 0x8f,
	0xda, 0xa7, 0x2f, 0xdb, 0xda, 0xe4, 0xa4, 0xd1, 0xed, 0xb5, 0xa8, 0x34, 0x91, 0x02, 0xda, 0xea,
	0x1c, 0x1f, 0x36, 0x1b, 0xa6, 0xa1, 0x04, 0xf4, 0xbb, 0xd3, 0xf6, 0xf1, 0xb9, 0x99, 0x45, 0x5f,
	0x8d, 0x5e, 0xf3, 0x85, 0x26, 0xbb, 0x9d, 0x06, 0x6d, 0x99, 0x39, 0xb9, 0xf3, 0x95, 0xd6, 0x4f,
	0x9d, 0x16, 0x3d, 0x3c, 0x69, 0xb5, 0x7b, 0x8d, 0x63, 0x33, 0xaf, 0x6c, 0x0e, 0x1a, 0xcd, 0xa3,
	0xb3, 0x8e, 0x59, 0xd0, 0xce, 0xba, 0xbd, 0x53, 0xa9, 0xba, 0xa1, 0x04, 0x2f, 0x4f, 0xe9, 0x91,
	0xbc, 0xa5, 0x68, 0x1b, 0x66, 0xe6, 0xc0, 0x06, 0x6b, 0x10, 0x8c, 0xeb, 0xb3, 0x60, 0x22, 0x26,
	0x7d, 0x56, 0x9f, 0x7a, 0x82, 0x71, 0xae, 0xff, 0x40, 0xf5, 0x0b, 0xf8, 0xf3, 0xec, 0xef, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xb0, 0x7e, 0xeb, 0x5d, 0x59, 0x0d, 0x00, 0x00,
}
