package main

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
	"strings"
	"time"

	"code.justin.tv/xangold/httpclient"
)

func findPartners(email string) (bool, error) {
	stmt := "SELECT Count(1) AS COUNT FROM users u INNER JOIN desktagger_user_properties up ON u.id = up.user_id AND up.NAME = 'partner_program' AND up.val = 'true' WHERE  email = $1"

	rows, err := siteDB.Query(stmt, email)
	if err != nil {
		return false, err
	}
	defer rows.Close()

	for rows.Next() {
		var count int
		err := rows.Scan(&count)
		if err != nil {
			return false, err
		}
		if count > 0 {
			return true, nil
		}
		return false, nil
	}
	return false, errors.New("count not found")
}

func findBanCount(username string) (int, error) {
	stmt := "select ump.tos_violation_count from user_moderation_properties ump JOIN users u on ump.user_id = u.id WHERE u.login = $1 LIMIT 1;"
	rows, err := siteDB.Query(stmt, username)
	if err != nil {
		return 0, err
	}
	defer rows.Close()

	for rows.Next() {
		var tosViolationCount int
		err := rows.Scan(&tosViolationCount)
		if err != nil {
			return 0, err
		}
		return tosViolationCount, nil
	}
	return 0, errors.New("count not found")
}

//we want to ignore statuses that are no
func ignoreStatus(status int) bool {
	if status != 200 && status != 201 && status != 404 && status != 422 {
		return true
	}
	return false
}

func checkIfPartner(username string) (bool, error) {
	fetchURL := "http://api.twitch.tv/api/channels/" + strings.TrimSpace(strings.ToLower(username))
	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	req, err := http.NewRequest("GET", fetchURL, nil)
	if err != nil {
		return false, err
	}
	resp, err := client.Do(req)
	if err != nil {
		return false, err
	}
	defer resp.Body.Close()
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return false, err
	}

	var data TwitchChannelAPI
	err = json.Unmarshal(body, &data)
	if err != nil {
		return false, err
	}
	return data.Partner, nil
}

func getTotalViewCount(username string) (int, error) {
	fetchURL := "https://api.twitch.tv/kraken/channels/" + strings.TrimSpace(strings.ToLower(username)+"client_id=22mh4r3t9ovb3nugu3oycdbp4o87l2q")
	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	req, err := http.NewRequest("GET", fetchURL, nil)
	if err != nil {
		return -1, err
	}
	resp, err := client.Do(req)
	if err != nil {
		return -1, err
	}
	defer resp.Body.Close()
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return -1, err
	}
	var data KrakenChannel
	err = json.Unmarshal(body, &data)
	if err != nil {
		return -1, err
	}
	return data.Views, nil

}

func setCaseLanguage(caseID string, language string) error {
	postURL := "https://help.twitch.tv/api/v2/cases/" + caseID
	m := make(map[string]map[string]string)
	m["custom_fields"] = map[string]string{"case_language": strings.ToLower(language)}

	payload, err := json.Marshal(m)
	if err != nil {
		return err
	}
	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	req, err := http.NewRequest("PATCH", postURL, bytes.NewBufferString(string(payload[:])))
	if err != nil {
		return err
	}
	header, err := GetOAuthHeader(req)
	if err != nil {
		return err
	}

	req.Header.Add("Authorization", header)
	resp, err := client.Do(req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	if ignoreStatus(resp.StatusCode) == true {
		return fmt.Errorf("Bad status for setting case language: %d", resp.StatusCode)
	}
	log.Printf("Successfully set case_language %s for case: %s Status: %d", language, caseID, resp.StatusCode)
	return nil

}
