package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
)

/*Get the email, name of a given customer*/
func getCaseCustomer(customerID string) (string, string, error) {
	client := &http.Client{Transport: tr}
	fetchURL := "https://help.twitch.tv/api/v2/customers/" + customerID
	req, err := http.NewRequest("GET", fetchURL, nil)
	if err != nil {
		return "", "", err
	}
	header, err := GetOAuthHeader(req)
	if err != nil {
		return "", "", err
	}
	req.Header.Add("Authorization", header)

	resp, err := client.Do(req)
	if err != nil {
		return "", "", err
	}
	defer resp.Body.Close()
	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return "", "", err
	}

	var data DeskCustomer
	err = json.Unmarshal(body, &data)
	if err != nil {
		return "", "", err
	}
	if len(data.Emails) > 0 {
		return data.Emails[0].Value, data.FirstName, nil
	}
	return "", "", fmt.Errorf("No email found. CustomerID: %s", customerID)

}
