package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
	"strconv"
	"time"

	"code.justin.tv/xangold/httpclient"
)

func getLast() (int, error) {
	fetchURL := "https://help.twitch.tv/api/v2/cases/search?labels=Payments+Found&per_page=1&sort_field=id&sort_direction=desc"
	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	req, err := http.NewRequest("GET", fetchURL, nil)
	if err != nil {
		return 0, err
	}
	req.Header.Add("Content-Type", "application/json")

	header, err := GetOAuthHeader(req)
	if err != nil {
		return 0, err
	}
	req.Header.Add("Authorization", header)

	resp, err := client.Do(req)
	if err != nil {
		return 0, err
	}

	defer resp.Body.Close()

	limit, err := strconv.Atoi(resp.Header.Get("X-Rate-Limit-Remaining"))
	if err != nil {
		log.Println(limit, err)
		return 0, err
	}

	if limit < 1 {
		return 0, fmt.Errorf("Over rate limit in getLast. Limit: %d", limit)
	}

	if ignoreStatus(resp.StatusCode) == true {
		return 0, fmt.Errorf("Bad status code for getLast: %d", resp.StatusCode)
	}

	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return 0, err
	}

	var data DeskCases
	err = json.Unmarshal(body, &data)
	if err != nil {
		return 0, err
	}
	return int(data.Embedded.Entries[0].Id), nil
}
