package main

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
	"strconv"
	"time"

	"code.justin.tv/xangold/httpclient"
)

var checkedCasesIDs = []int{}

func checkForNew() {
	for {
		time.Sleep(30 * time.Second)
		go func() {
			log.Printf("Initiating search for new work. Checking: %s", newCasesURL(lastUpdatedCase))
			if err := getNewCases(newCasesURL(lastUpdatedCase)); err != nil {
				log.Printf("Error getting new cases: %v", err)
			}
		}()
	}
}

func newCasesURL(caseID int) string {
	return fmt.Sprintf("/api/v2/cases/search?q=status:new&since_id=%d&per_page=100&sort_field=id&sort_direction=desc", caseID+1)
}

func getNewCases(self string) error {
	fetchURL := "https://help.twitch.tv" + self
	log.Printf("getting cases to process. %s ", fetchURL)
	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	req, err := http.NewRequest("GET", fetchURL, nil)
	if err != nil {
		return err
	}
	header, err := GetOAuthHeader(req)
	if err != nil {
		return err
	}

	req.Header.Add("Authorization", header)

	resp, err := client.Do(req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	if resp.StatusCode != http.StatusOK {
		return err
	}

	body, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return err
	}
	var data DeskCases
	err = json.Unmarshal(body, &data)
	if err != nil {
		return err
	}
	for _, item := range data.Embedded.Entries {
		work := WorkRequest{CaseType: "desk_case", CaseID: strconv.Itoa(int(item.Id))}
		WorkQueue <- work
	}
	return nil
}
