package main

import (
	"fmt"
	"log"
	"regexp"
	"strconv"
	"strings"
	"time"
)

func parseGeneralCase(caseID string, message string, email string, firstName string) error {
	payments := 0
	payments, err := AdminGetPayments(email)
	if err != nil {
		return err
	}
	if payments > 0 {
		if err := updateLabels(caseID, []string{"Payments Found"}, "6"); err != nil {
			return err
		}
	}
	language, err := getAdminData(firstName)
	if err != nil {
		return err
	}
	if err := setCaseLanguage(caseID, language); err != nil {
		return fmt.Errorf("error setting language on caseID %s", caseID)
	}
	return nil
}

//given the message, get a valid youtube, and followers based around it.
func parseYoutube(message string) string {
	yt_regex := regexp.MustCompile("((http|https):\\/\\/|)(www.|)youtube\\.com\\/(channel\\/|user\\/|)[a-zA-Z0-9_]{1,}")
	youtube_name := yt_regex.FindString(message)
	youtube_name_a := strings.Split(youtube_name, "/")

	if len(youtube_name_a) != 0 {
		youtube_name = strings.TrimSpace(youtube_name_a[len(youtube_name_a)-1])
		//log.Info("youtube name is " + youtube_name)
		youtubeData, err := getYoutubeSubscribers(youtube_name)
		if err != nil {
			return err.Error() + "\n"
		} else {
			return youtubeData + "\n"
		}
	}
	return "Error processing youtube stuff" + "\n"
}

//given the message, get a valid twitter username, and followers based around it.
func parseTwitter(message string) string {
	t_regex := regexp.MustCompile("((http|https):\\/\\/|)(www.|)twitter\\.com\\/[a-zA-Z0-9_]{1,}")
	twitter_name := t_regex.FindString(message)
	twitter_name_a := strings.Split(twitter_name, "/")

	if len(twitter_name_a) != 0 && twitter_name != "" {
		twitter_name = strings.ToLower(twitter_name_a[len(twitter_name_a)-1])
		twitterData, err := getTwitterFollowers(twitter_name)
		if err != nil {
			return err.Error() + "\n"
		} else {
			return twitterData + "\n"
		}
	}
	return "Error processing twitter stuff" + "\n"

}

/*Tag partner apps with a bunch of information like # of twitter followers, youtube subscribers, viewbot percent, past bans, etc.*/
func parsePartnerAppsCase(caseID string, message string, email string, firstName string) error {
	r := regexp.MustCompile("\\shttps://www\\.twitch\\.tv.*\\s")
	username := ""
	username = r.FindString(message)
	username_a := strings.Split(username, "/")
	username = strings.TrimSpace(username_a[len(username_a)-1])

	noteMessage := "Application case for " + username + "\n"

	if username == "" {
		return fmt.Errorf("Username not found %s", username)
	}

	language, err := getAdminData(strings.ToLower(username))
	if err != nil {
		log.Printf("error getting admin data %v", err)
		return err
	}
	views := 0
	views, err = getTotalViewCount(strings.ToLower(username))
	if err != nil {
		views = 0
	}
	log.Printf("Attempting to set case language for case %s to %s", caseID, language)
	if err := setCaseLanguage(caseID, language); err != nil {
		log.Printf("Error setting language on case %s %v", caseID, err)
	}

	noteMessage = noteMessage + "Views: " + strconv.Itoa(views) + "\n"

	noteMessage = noteMessage + "Youtube Subs: " + parseYoutube(message)
	noteMessage = noteMessage + "Twitter Followers: " + parseTwitter(message)
	oldTime := time.Unix(time.Now().Unix()-5184000, 0).Format("2006-01-02")
	curTime := time.Now().Format("2006-01-02")

	concurrents, conError := getConcurrents(username, oldTime, curTime)
	if conError != nil {
		log.Printf("Error getting concurrents: %v", err)
	}

	minBroadcast, avgViewers, chatActivity, err := getMixpanelStats(username)
	if err != nil {
		return fmt.Errorf("Error getting mixpanel stats: %v", err)
	}

	noteMessage = noteMessage + "Language: " + language + "\n"
	noteMessage = noteMessage + "Hours broadcast per day: " + FloatToString(float64(minBroadcast)/60.0/60.0) + "\n"
	noteMessage = noteMessage + "Average real viewership: " + FloatToString(avgViewers) + "\n"
	noteMessage = noteMessage + "Average chat per minute broadcasting: " + FloatToString(chatActivity) + "\n"
	if conError == nil {
		noteMessage = noteMessage + "Average Concurrents (may be botted): " + FloatToString(concurrents) + "\n"
	}

	banCount, banErr := findBanCount(strings.ToLower(username))
	if banErr == nil {
		noteMessage = noteMessage + "User account suspensions: " + strconv.Itoa(banCount) + "\n"
	}

	go postNote(caseID, noteMessage)
	return nil
}

func FloatToString(input_num float64) string {
	return strconv.FormatFloat(input_num, 'f', 6, 64)
}
