package main

//Add a note into desk case.
import (
	"bytes"
	"encoding/json"
	"fmt"
	"net/http"
	"strconv"
	"strings"
	"time"

	"code.justin.tv/xangold/httpclient"
)

func postNote(caseID string, message string) error {
	postURL := "https://help.twitch.tv/api/v2/cases/" + caseID + "/notes"
	//I feel there is a lot of cleanup that can happen in this function. When I remove the ToLower() it fails
	payload, err := json.Marshal(&NotePayload{Body: message})
	if err != nil {
		return err
	}
	client := httpclient.GetHTTPClient(30*time.Second, 30*time.Second)
	req, err := http.NewRequest("POST", postURL, bytes.NewBufferString(strings.ToLower(string(payload[:]))))
	if err != nil {
		return err
	}
	header, err := GetOAuthHeader(req)
	if err != nil {
		return err
	}

	req.Header.Add("Authorization", header)

	resp, err := client.Do(req)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	limit, err := strconv.Atoi(resp.Header.Get("X-Rate-Limit-Remaining"))
	if err != nil {
		return err
	}
	if limit < 1 {
		_, err := strconv.Atoi(resp.Header.Get("X-Rate-Limit-Reset"))
		if err != nil {
			return err
		}
		return fmt.Errorf("posting note. Status Code: %d Limit: %d", resp.StatusCode, limit)
	}
	if ignoreStatus(resp.StatusCode) == true {
		return fmt.Errorf("Bad status code for posting note: %d", resp.StatusCode)
	}
	if resp.StatusCode != 201 {
		return fmt.Errorf("Bad status posting note %d", resp.StatusCode)
	}
	return nil
}
