Go-Multiconfig
==============

Multiconfig is a library for parsing configs. It will search a JSON config
file, environment variables and command line flags for your config option.

This makes it easy to configure code that will load config options from a
combination of env variables, flags and config files. Allowing production to
use config files, docker to use environment variables and a dev to use command
line flags.

All sources are checked in order of priority:

- Command line flag
- Environment Variable
- Config file
- Default value supplied via code

The config file will by default be loaded from `config.json` in the running
directory, but can alternatively be set from `CONFIG=""` environment variable or
the `-config` command line flag.

**Warning**: `-config` is a reserved command line flag and can not be used by
your program.

[Godoc](http://godoc.internal.justin.tv/git.internal.justin.tv/common/go-multiconfig)

Environment Variables
=====================

When parsing environment variables the flag name is transformed to all caps
with hyphens replaced with underscores. This is to more closely match how
environment variables are normally stored.

Example:

* foo => FOO
* foo-api-token => FOO_API_TOKEN


Examples
========

Given the following line of code:

```go
var myValue string
multiconfig.StringVar(&myValue, "flag_name", "default value", "This is a help message for flag_value")
```

You will end up with:

Flag name of `-flag_name`
Environment variable of `FLAG_NAME` (all caps version of the name argument)
Config Entry of `flag_name`

Limitations
-----------

- Only StringVar and IntVar are implemented.
- Only one level depth k/v JSON is supported.

TODO
----

- [ ] Add FloatVar
- [ ] Add DurationVar
- [ ] Add Var
- [ ] Add Nested JSON support
