package multiconfig

import (
	"fmt"
	"testing"
)

type TestIntCase struct {
	name          string
	envVal        string
	configVal     string
	flagVal       string
	defaultVal    int
	expectedValue int
	shouldErr     bool
}

func (t *TestIntCase) testEnv(name string) string {
	return t.envVal
}

var intTestCases = []TestIntCase{
	{
		name:          "flagTest",
		envVal:        "50",
		configVal:     "80",
		flagVal:       "100",
		defaultVal:    5,
		expectedValue: 100,
		shouldErr:     false,
	},
	{
		name:          "envTest",
		envVal:        "50",
		configVal:     "80",
		expectedValue: 50,
		defaultVal:    5,
		shouldErr:     false,
	},
	{
		name:          "configTest",
		configVal:     "80",
		expectedValue: 80,
		defaultVal:    5,
		shouldErr:     false,
	},
	{
		name:          "defaultTest",
		expectedValue: 5,
		defaultVal:    5,
		shouldErr:     false,
	},
	{
		name:          "floatTest",
		configVal:     "9.9",
		expectedValue: 5,
		shouldErr:     true,
	},
}

func TestInt(t *testing.T) {
	for _, c := range intTestCases {
		var dest int

		config := NewConfig()
		config.envGetter = c.testEnv
		if c.flagVal != "" {
			config.args = []string{fmt.Sprintf("-%s", c.name), c.flagVal}
		}

		if c.configVal != "" {
			config.config[c.name] = c.configVal
		}

		config.IntVar(&dest, c.name, c.defaultVal, "the foo var")

		err := config.Parse()
		if err != nil && !c.shouldErr {
			t.Errorf("TestInt[%s] encountered err: %v", c.name, err)
			continue
		}

		if err == nil && c.shouldErr {
			t.Errorf("TestInt[%s] should have errored.", c.name)
			continue
		}

		if !c.shouldErr && dest != c.expectedValue {
			t.Errorf("TestInt[%s] Got %d; expected %d", c.name, dest, c.expectedValue)
		}
	}
}
