package multiconfig

import (
	"fmt"
	"testing"
)

type TestStringCase struct {
	name          string
	envVal        string
	configVal     string
	flagVal       string
	defaultVal    string
	expectedValue string
	shouldErr     bool
}

func (t *TestStringCase) testEnv(name string) string {
	return t.envVal
}

var strTestCases = []TestStringCase{
	{
		name:          "flagTest",
		envVal:        "foo",
		configVal:     "bar",
		flagVal:       "baz",
		defaultVal:    "bat",
		expectedValue: "baz",
		shouldErr:     false,
	},
	{
		name:          "envTest",
		envVal:        "foo",
		configVal:     "bar",
		defaultVal:    "bat",
		expectedValue: "foo",
		shouldErr:     false,
	},
	{
		name:          "configTest",
		configVal:     "bar",
		defaultVal:    "bat",
		expectedValue: "bar",
		shouldErr:     false,
	},
	{
		name:          "defaultTest",
		defaultVal:    "bat",
		expectedValue: "bat",
		shouldErr:     false,
	},
}

func TestString(t *testing.T) {
	for _, c := range strTestCases {
		var dest string

		config := NewConfig()
		config.envGetter = c.testEnv
		if c.flagVal != "" {
			config.args = []string{fmt.Sprintf("-%s", c.name), c.flagVal}
		}

		if c.configVal != "" {
			config.config[c.name] = c.configVal
		}

		config.StringVar(&dest, c.name, c.defaultVal, "the foo var")

		err := config.Parse()
		if err != nil && !c.shouldErr {
			t.Errorf("TestString[%s] encountered err: %v", c.name, err)
			continue
		}

		if err == nil && c.shouldErr {
			t.Errorf("TestString[%s] should have errored.", c.name)
			continue
		}

		if !c.shouldErr && dest != c.expectedValue {
			t.Errorf("TestString[%s] Got %s; expected %s", c.name, dest, c.expectedValue)
		}
	}
}
