/* global module */
module.exports = {
    parserOptions: {
        ecmaFeatures: {
            jsx: true,
        },
        ecmaVersion: 6,
        sourceType: 'module',
    },
    plugins: [
        'import',
        'sorting',
        'react',
        'jsx-a11y',
        'lodash',
        'twitch',
    ],
    rules: {
        'array-bracket-spacing': ['error', 'never'],
        'arrow-parens': ['error', 'as-needed'],
        'arrow-spacing': 'error',
        'brace-style': ['error', '1tbs'],
        camelcase: ['error', { properties: 'always' }],
        'comma-dangle': ['error', 'always-multiline'],
        'comma-style': ['error', 'last'],
        complexity: ['error', { max: 10 }],
        'dot-notation': 'error',
        'dot-location': 'error',
        'eol-last': 'error',
        eqeqeq: 'error',
        'func-style': ['error', 'declaration', { allowArrowFunctions: true }],
        indent: [
            'error',
            4,
            {
                ImportDeclaration: 'first',
                MemberExpression: 'off',
            },
        ],
        'jsx-a11y/label-has-for': [2, {
            required: 'id',
        }],
        'jsx-quotes': 'error',
        'key-spacing': 'error',
        'keyword-spacing': 'error',
        'max-len': ['error', 120],
        'max-statements': ['error', { max: 20 }, { ignoreTopLevelFunctions: true }],
        'max-statements-per-line': 'error',
        'new-cap': 'error',
        'new-parens': 'error',
        'no-console': 'error',
        'no-duplicate-imports': 'error',
        'no-else-return': 'error',
        'no-floating-decimal': 'error',
        'no-lone-blocks': 'error',
        'no-lonely-if': 'error',
        'no-loop-func': 'error',
        'no-multiple-empty-lines': ['error', { max: 1 }],
        'no-nested-ternary': 'error',
        'no-param-reassign': ['error', { props: true }],
        'no-self-compare': 'error',
        'no-trailing-spaces': 'error',
        'no-unused-expressions': 'error',
        'no-unused-vars': ['error', {
            argsIgnorePattern: '^_',
        }],
        'no-useless-concat': 'error',
        'no-useless-escape': 'error',
        'no-var': 'off',
        'no-whitespace-before-property': 'error',
        'object-curly-spacing': ['error', 'always'],
        'object-property-newline': 'error',
        'object-shorthand': ['error', 'methods'],
        'one-var': ['error', 'never'],
        'padded-blocks': ['error', 'never'],
        'prefer-const': 'error',
        'prefer-template': 'error',
        'quote-props': ['error', 'as-needed'],
        quotes: ['error', 'single'],
        radix: 'error',
        'react/jsx-boolean-value': ['error', 'always'],
        'react/jsx-closing-bracket-location': 'error',
        'react/jsx-curly-spacing': 'error',
        'react/jsx-filename-extension': 'error',
        'react/jsx-first-prop-new-line': ['error', 'multiline'],
        'react/jsx-no-bind': 'error',
        'react/jsx-pascal-case': 'error',
        'react/jsx-tag-spacing': ['error', { beforeSelfClosing: 'always' }],
        'react/jsx-wrap-multilines': 'error',
        'react/no-is-mounted': 'error',
        'react/no-multi-comp': 'error',
        'react/no-string-refs': 'error',
        'react/prefer-stateless-function': 'error',
        'react/require-render-return': 'error',
        'react/self-closing-comp': 'error',
        semi: ['error', 'always'],
        'semi-spacing': 'error',
        'space-before-blocks': 'error',
        'space-before-function-paren': ['error', 'never'],
        'space-in-parens': ['error', 'never'],
        'space-infix-ops': 'error',
        'spaced-comment': ['error', 'always', {
            block: {
                exceptions: ['*'],
            },
        }],
        'template-curly-spacing': 'error',
        'twitch/no-window-find': 'error',
        'lodash/import-scope': [2, 'method'],
    },
    env: {
        es6: true,
        browser: true,
    },
    globals: {
        _: true,
        require: true,
        module: true,
    },
    settings: {
        propWrapperFunctions: ['Object.freeze'],
    },
    extends: ['eslint:recommended', 'plugin:react/recommended', 'plugin:jsx-a11y/recommended'],
};
