/* global __dirname, process, module */
var path = require('path');
// eslint-disable-next-line no-unused-vars
var fs = require('fs');
var Testem = require('testem');

// eslint-disable-next-line no-unused-vars
var SRC_PATH = path.resolve(__dirname, 'src');
var DEST_PATH = path.resolve(__dirname, 'build');
// eslint-disable-next-line no-unused-vars
var DEV_MODE = (process.env.NODE_ENV !== 'production');
var IS_ROOT = !!(process.getuid && process.getuid() === 0);

module.exports = function(grunt) {
    // `default` task: clean the output directory and build all assets
    grunt.registerTask('default', ['clean', 'build']);
    // `build` task: build all assets
    grunt.registerTask('build', ['clean:build', 'exec:generate_spade_host', 'webpack:player', 'webpack:embed']);
    // `serve` task: serve assets from the build directory
    grunt.registerTask('serve', ['browserSync']);
    // `dev` task: build assets, then serve them
    grunt.registerTask('dev', (IS_ROOT ? ['serve'] : ['clean', 'build', 'serve']));

    grunt.registerTask('test:ci:remote', ['clean:tests', 'webpack:tests', 'exec:testem_ci_remote']);
    grunt.registerTask('test:ci:local', ['clean:tests', 'webpack:tests', 'exec:testem_ci_local']);
    grunt.registerTask('test:dev', 'Development mode for running tests', function() {
        // ensure the webpack:tests task keeps itself alive, but does not print
        // anything to the console; this seems to screw up Testem.
        grunt.config.set('webpack.tests.keepalive', true);
        grunt.config.set('webpack.tests.stats', false);
        grunt.config.set('webpack.tests.progress', false);
        grunt.config.set('webpack.tests.watch', true);
        grunt.task.run(['clean:tests', 'webpack:tests']);

        var testem = new Testem();
        var config = require('./testem.json');
        testem.startDev(Object.assign(config, {
            growl: process.env.GROWL === 'true',
        }));
    });

    grunt.loadNpmTasks('grunt-webpack');
    grunt.loadNpmTasks('grunt-browser-sync');
    grunt.loadNpmTasks('grunt-contrib-clean');
    grunt.loadNpmTasks('grunt-exec');

    grunt.initConfig({
        localization: grunt.file.readJSON(path.resolve(__dirname, 'config', 'smartling.config.json')),
        webpack: require('./config/webpack-grunt.js'),
        clean: {
            build: [DEST_PATH],
            tests: [path.resolve(__dirname, 'tests/build')],
        },
        exec: {
            // eslint-disable-next-line camelcase
            testem_ci_remote: {
                command() {
                    return './node_modules/.bin/testem ci --file=testem-docker.json --launch Chrome';
                },
                options: {
                    maxBuffer: Infinity,
                },
            },
            // eslint-disable-next-line camelcase
            testem_ci_local: {
                command() {
                    return './node_modules/.bin/testem ci --launch Chrome --port=7358';
                },
                options: {
                    maxBuffer: Infinity,
                },
            },
            // eslint-disable-next-line camelcase
            generate_spade_host: {
                command() {
                    return './tasks/generate_spade_config.sh';
                },
            },
        },
        browserSync: {
            dev: {
                bsFiles: {
                    src: [
                        path.join(DEST_PATH, '**/*'),
                    ],
                },
                options: {
                    https: true,
                    host: 'localhost.twitch.tv',
                    port: (IS_ROOT ? 80 : 8000),
                    open: 'external',
                    startPath: '?channel=monstercat&debug=true',
                    server: {
                        baseDir: DEST_PATH,
                    },
                },
            },
        },
    });

    grunt.loadTasks('tasks');
};
