player-ui [![Build Status](https://jenkins.internal.justin.tv/job/video-player-ui-deploy/badge/icon)](https://jenkins.internal.justin.tv/job/video-player-ui-deploy/)
=========

Universal Player UI for Web Playback.

For External Developers
=======================
We now automatically deploy the latest master to production.

**If you would like to push a change to this codebase that should be deployed to production you must**:

1) Create a JIRA task to track your changes. Please select `Video Playback` as the `Project`. Fill out `Description`.

2) **All commits** should have the JIRA task number preprended to the commit title. `VP-480: This is a commit title`. Every commit should have a **multi-word description** with reasons behind its changes.

3) **The onus is on you to make your PR easy to code review.** Your PR should **only contain changes pertaining to your PR**. It should be easy to read and understand by reading successive atomic commits.

4) When you create your PR, prepend the title with the JIRA task number. `VP-480: Hi, I'm a PR.` and add it to the [Video Playback Scrum's](https://twitchtv.atlassian.net/secure/RapidBoard.jspa?rapidView=176&view=planning.nodetail) active sprint.

5) Fill out the `Acceptance Criteria` field of the JIRA task. We should be able to confirm your change from following the `Acceptance Criteria`.

6) Ensure that your change works on all major browsers. (Chrome, Firefox, Safari)

7) PR's with no unit tests will __not__ be merged in.

8) You must receive 2 LGTMs (more is preferred for bigger changes) before merging. You must add a link to your PR to the `#player-prs` chat on Slack.

9) After your PR builds, passes our smoca tests, and has 2+ LGTM's, your PR is ready to merge.

10) Fill out the [Change Request Ticket](https://jira.twitch.com/secure/CreateIssueDetails!init.jspa?pid=12600&issuetype=15301&priority=6&customfield_20105=N/A&customfield_20106=This%20change%20will%20be%20deployed%20via%20the%20standard%20Player-UI%20release%20process.%20See%20https%3A%2F%2Fgit-aws.internal.justin.tv%2Fvideo%2Fplayer-ui%2Fwiki%2FContinuous-Deployment-Process%20for%20more%20details.&customfield_20103=This%20change%20has%20passed%20Player-UI%20linting,%20unit%20tests,%20integration%20tests,%20and%20acceptance%20tests.%20See%20the%20PR%20linked%20in%20the%20description%20for%20more%20details.&customfield_20104=N/A&customfield_20003=The%20change%20is%20deployed%2C%20working%20as%20expected%2C%20and%20is%20not%20producing%20runtime%20errors&customfield_20300=In%20the%20event%20of%20a%20problem%2C%20the%20change%20would%20be%20rolled%20back%20by%20VP%20on-call%20using%20the%20Rollback%20steps%20outlined%20here%20https%3A%2F%2Fgit-aws.internal.justin.tv%2Fvideo%2Fplayer-ui%2Fwiki%2FOn-Call-Troubleshooting-Steps%23rollback.%20Please%20ping%20in%20%23video-playback%20to%20get%20their%20attention.).

11) Merge your PR into master and mark the corresponding Jira ticket as merged. It will be auto deployed to production. Be careful when you merge your changes. You are immediately responsible for supporting your change, once it is in master. **Merges to master are not allowed on Friday afternoons**

12) Confirm your changes are working in production.

13) If, for any reason, master fails from your PR, you are responsible for fixing it. The earlier you merge your PR in, the more time you have to fix any problems. Do not leave master in a bad state. We will revert if we have to, but we prefer not to.

**We will not accept PRs if they do not follow this process.**

**Note** - We will regularly delete branches that have been left unattended for over a month with no updates. If you have a good reason to keep a branch around without making any changes, let #video-playback know and we can apply the protected status to that branch.

Development Steps
=================

If you do not already have a hosts entry for your local machine, run the
following command:

```shell
sudo echo "127.0.0.1  localhost.twitch.tv" >> /etc/hosts
```

You'll need yarn v1.1.0 installed. With homebrew:

```
$ brew install yarn
```

Install node v6.11.x from the [official 6.x download page](https://nodejs.org/dist/latest-v6.x/).

To install all other dependencies run:
```shell
yarn install
```

Before you start development on this repo, you should run the following command to set up githooks:
```shell
scripts/setup_hooks
```

and create a production build locally that generates artifacts (eg. TwitchPlayer.swf) which are also used during development:
```shell
yarn build
```

To start the development server (with automatic browser sync), run:

```shell
yarn start
```

This will automatically build the project as well as host it locally, pointed at
production data. You will need to have run the previous command appending a line
to your `/etc/hosts` file for this to work correctly; many of the API calls in
the critical path to loading video require CORS access, which is only granted to
requests matching the wildcard domain `*.twitch.tv`.

You can also run a local web server (such as NGINX or Apache) pointed at
`$(cwd)/build`; this can be helpful when testing under HTTPS, as the current
system explicitly does not load the page under HTTPS. Note that this should be
changed when the site switches to HTTPS Everywhere *and* video is served over
HTTPS.

To load specific channels, change the URL to `localhost.twitch.tv:8000?channel=<YOUR_CHANNEL>`,
and to load VOD content, use `localhost.twitch.tv:8000?video=v<VIDEO_ID>`.

[Here is the full list of available parameters](https://dev.twitch.tv/docs/v5/guides/embed-video/).

## Redux Developer Tools

Player UI uses [Redux](https://github.com/reactjs/redux) for internal state management.
Redux is an open-source project and has a number of useful development tools &
extensions; the player codebase integrates with the [Redux Developer Tools Chrome
Extension](https://github.com/zalmoxisus/redux-devtools-extension), which allows
developers to watch the state changes in the player as they happen, along with a
number of other niceties.

Install it from the [Chrome Web
Store](https://chrome.google.com/webstore/detail/redux-devtools/lmhkpmbekcpmknklioeibfkpmmfibljd)

Testing
=======
We use jest as our testing framework and test runner. We also have legacy tests that run on QUnit and testem. You will also need to install [PhantomJS](http://phantomjs.org/). Please add tests for any changes you make to prevent regressions.

We have the following commands to run tests:
* ```yarn test``` - This command will run all tests in CI mode and let you know if any failed. This is also run as part of the githook before pushing, and run on Jenkins during the build.
* ```yarn test-watch``` - This command will boot up a server you can use to run / debug the tests in a browser. Upon changing any files, the process will rebuild the test files automatically, and you can simply refresh to see your changes.
* ```yarn lint``` - This command will run the linter which is automatically run in our precommit hook.
* ```yarn test-jest``` - This command will run jest in watch mode. It will automatically refresh with each save.
* ```yarn test-jest:debug``` - This command will run jest with node inspector. It will allow you to set break points and step through your tests.

Migrating QUnit to jest
========================
To facilitate the migration of tests to jest, use the following command
* ```yarn migrate-test tests/src/js/path/to/test``` - This command will copy the test to it's mirror in the ```__tests__``` folder and run the jscodeshift on it. 
    - Some tests will not convert over 100%, so please take the time to go through and manually migrate tests cases to jest.

Internationalization
====================
How To Translate Strings Used in Player UI:

1) Add strings to [`strings.pot`](https://git-aws.internal.justin.tv/video/player-ui/blob/master/localization/strings.pot)

2) When a language changes, you can update the strings by using react-i18next's `translate` HOC, which will provide a `t` function to use for translation to your component.

3) Merge your localization changes into master.

4) After you localization changes are in master, create a branch off of it, (historically called `update_localization`), run `yarn i18n` and submit a PR with the results of that command. (This PR may include translations unrelated to your changes, but that's okay.) This will push your strings up for Smartling (a translation service) to translate. Clone this [JIRA Issue](https://jira.twitch.com/browse/LOC-128), fill in the necessary information, and add it to the PR description.

5) After your PR is merged, get the strings approved for translation in Smartling. With the JIRA issue created in the previous step, ping Noelle Plat (@noelplat) on Slack or email her (noelplat@twitch.tv) for translation approval.

6)  After Noelle notifies you, or you know that your strings have been translated, run `yarn i18n` and submit a PR with results of the command. This will pull the new translations of your string from the Smartling service down into our player.

Note: To set a language, use the `setLanguage` method in player.js.
