// Empty backend used to define the Backend "interface".
//
// All methods are defined in the same order as the spec:
// http://dev.w3.org/html5/spec-author-view/video.html#mediaevents

import EventEmitter from 'event-emitter';
import { createMockQualities } from 'test-utils/fakes/qualities';

export const BACKEND_BLANK_TYPE = 'blank';
export const BACKEND_BLANK_ERROR = new Error('BLANK');

export class BackendBlank {
    constructor() {
        this._events = new EventEmitter();
        this._destructables = [];
    }
    attach() {}
    destroy() {
        this._destructables.forEach(([name, func]) => {
            this.removeEventListener(name, func);
        });
    }
    getVersion() {
        return '';
    }
    addEventListener(name, func) {
        this._events.on(name, func);
        this._destructables.push([name, func]);
    }
    removeEventListener(name, func) {
        this._events.off(name, func);
    }
    getError() {
        return BACKEND_BLANK_ERROR;
    }
    getSrc() {}
    getStats() {
        return {};
    }
    setSrc() {}
    getNetworkState() {}
    getBuffered() {}
    load() {}
    getReadyState() {}
    getSeeking() {}
    getCurrentTime() {
        return this._time;
    }
    setCurrentTime(time) {
        this._time = time;
    }
    getDuration() {}
    getPaused() {}
    getPlaybackRate() {}
    setPlaybackRate() {}
    getPlayed() {}
    getEnded() {}
    getAutoplay() {}
    setLoop() {}
    play() {}
    pause() {}
    getControls() {}
    setControls() {}
    getVolume() {}
    setVolume() {}
    getMuted() {}
    setMuted() {}
    getQuality() {}
    setQuality() {}
    getQualities() {
        return createMockQualities();
    }
    setChannel() {}
    elapsedTime() {}
    setVideo() {}
    getVideoInfo() {
        return {};
    }
    getCaption() {}
    getBackend() {
        return BACKEND_BLANK_TYPE;
    }
    absAvailable() {
        return true;
    }
}
