import sinon from 'sinon';
import { DEFAULT_STATS } from 'state/stats';
import { BackendBlank } from './blank-backend';

export class BackendPlayerCore extends BackendBlank {
    constructor() {
        super();
        this.stats = DEFAULT_STATS;
        this.videoInfo = {};
        sinon.spy(this, 'addEventListener');
    }

    attach(element) {
        this.media = element;
    }

    loadURL() {}

    _setPlaybackStatistics(stats) {
        this.stats = stats;
    }

    _setVideoInfo(videoInfo) {
        this.videoInfo = videoInfo;
    }

    getPlaybackStatistics() {
        return this.stats;
    }

    setQuality(quality) {
        this.quality = quality;
    }

    getQuality() {
        return this.quality;
    }

    getVideoInfo() {
        return this.videoInfo;
    }

    stop() {}

    destroy() {}

    getVersion() {
        return 'v1.0.0';
    }

    paused() {
        return this.media.paused;
    }

    ended() {
        return this.media.ended;
    }

    play() {
        return this.media.play();
    }

    pause() {
        return this.media.pause();
    }

    getBackend() {
        return BACKEND_PLAYER_CORE;
    }
}

BackendPlayerCore.canPlay = () => true;

export const Event = Object.freeze({
    HLS_MASTER_PARSED: 'hlsmanifestparsed',
    HLS_VARIANT_PARSED: 'hlsvariantparsed',
    VARIANT_SWITCH_REQUESTED: 'renditionswitchrequested',
    SEGMENT_CHANGED: 'segmentchange',
    SPLICEOUT: 'spliceout',
    SPLICEIN: 'splicein',
    CAPTION: 'caption',
    AUTH_ERROR: 'autherror',
    CORE_ANALYTICS: 'coreanalytics',
    OFFLINE: 'offline',
    BUFFERING: 'buffering',
    FATAL_ERROR: 'fatal_error',
});

export const BACKEND_PLAYER_CORE = 'player-core';
