class ExtensionService {
    constructor() {
        this.getInstalledExtensions = jest.fn();
        this.subscribeToExtensionControl = () => {};
        this.registerPlayer = jest.fn();
        this.unregisterPlayer = jest.fn();
        this.listenForContext = jest.fn();
        this.postContext = jest.fn();
    }
}

export class ExtensionFrame {
    constructor(params) {
        const options = params || {};

        this.destroy = jest.fn();
        this.on = jest.fn();
        this.off = jest.fn();
        this.linkIdentity = jest.fn();
        this.unlinkIdentity = jest.fn();

        this.extension = options.extension;
        this.mode = options.mode;
        this.language = options.language;
        this.locale = options.locale;
    }
}

export const ExtensionCoordinator = {
    ExtensionService: new ExtensionService(),
    ExtensionFrame: ExtensionFrame,
};
