import identity from 'lodash/identity';

function changeLanguage(language, cb) {
    cb(false, identity);
}

function use() {
    return this;
}

export var missingKeyHandler;
export var saveMissing;

function init(params) {
    missingKeyHandler = params.missingKeyHandler;
    saveMissing = params.saveMissing;
}

function getFixedT() {
    return identity;
}

const options = {
    ns: [],
    defaultNS: 'translation',
    interpolation: {
        formatSeparator: ',',
        format() {},
    },
};

const services = {
    interpolator: {
        regexp: /.*/,
    },
    logger: {
        warn() {},
    },
};

export default {
    changeLanguage,
    use,
    addResourceBundle() {},
    getFixedT,
    init,
    loadNamespaces() {},
    off() {},
    on() {},
    options,
    services,
};
