import sinon from 'sinon';

export class PubSubClient {
    constructor() {
        this.Listen = sinon.spy();
        this.Unlisten = sinon.spy();
    }

    sendMessage(message) {
        this.sendRawMessage(JSON.stringify(message));
    }

    sendRawMessage(messageStr) {
        for (let i = 0; i < this.Listen.callCount; i++) {
            this.Listen.getCall(i).args[0].message(messageStr);
        }
    }

    _reset() {
        this.Listen.reset();
        this.Unlisten.reset();
    }
}

const instance = new PubSubClient();

export default {
    getInstance() {
        return instance;
    },
};
