export default class FakeResizeObserver {
    constructor(resizeCallback) {
        this._resizeCallback = resizeCallback;
        this._observeElements = [];
    }

    observe(element) {
        this._observeElements.push({
            target: element,
            contentRect: {
                left: element.style.left,
                top: element.style.top,
                width: element.style.width,
                height: element.style.height,
            },
        });
    }

    _triggerResize() {
        this._resizeCallback(this._observeElements);
    }

    unobserve() { }

    disconnect() { }
}
