export const CONTENT_MODE_PROVIDED = 'provided';

export class ProvidedContentStream {
    constructor({ customerId, contentId, usherHostOverride }) {
        this._customerId = customerId;
        this._contentId = contentId;
        this._usherHostOverride = usherHostOverride;
    }

    get contentType() {
        return CONTENT_MODE_PROVIDED;
    }

    get channel() {}
    get videoId() {}

    get contentId() {
        return this._contentId;
    }

    get customerId() {
        return this._customerId;
    }

    get _baseStreamUrl() {
        return '';
    }

    get accessToken() {
        return Promise.resolve();
    }

    resetNAuthToken() {}
    _buildUsherParams() {}

    get streamUrl() {
        return Promise.resolve('');
    }

    _fetchNAuthToken() {
        return Promise.reject('Error: Attempted NAuth fetch for ProvidedContentStream');
    }

    _fetchAccessToken() {
        return Promise.reject('Error: Attempted Access Token fetch for ProvidedContentStream');
    }

    get castStreamUrl() {
        return Promise.resolve('');
    }
}
