import assign from 'lodash/assign';
import * as AccessTokenActions from 'actions/access-token';

describe('actions | access-token', function() {
    describe('setAccessTokenParams', function() {
        test('selects only the whitelisted access token override parameters', function() {
            const whitelistedParams = [
                'need_https',
            ];
            const params = whitelistedParams.reduce((props, param) => {
                return assign(props, { [param]: param });
            }, { wrong: true });

            const action = AccessTokenActions.setAccessTokenParams(params);

            expect(Object.keys(action.params).sort()).toEqual(whitelistedParams.sort());
        });
    });
});
