import { BACKEND_PLAYER_CORE } from 'backend/player-core';
import { BACKEND_FLASH } from 'backend/flash';
import { BACKEND_HLS } from 'backend/hls';
import { BACKEND_MEDIA_PLAYER } from 'backend/mediaplayer';
import { ACTION_CREATE_ADS_MANAGER, createAdsManager } from 'actions/ads-manager';
import { IMAManager } from 'ads/ima-manager';
import { DecliningAdsManager } from 'ads/declining-manager';
import { FlashManager } from 'ads/flash-manager';
import { init as initStore } from 'state';

describe('actions | ads-manager', function() {
    let store;
    const rootElm = document.createElement('div');

    beforeEach(function() {
        store = initStore();
    });

    describe('createAdsManager', function() {
        function testCreateAdsManager(backendType, managerType, message) {
            test(message, function() {
                const backend = {
                    addEventListener() {
                    },

                    getBackend() {
                        return backendType;
                    },
                };

                const { type, adsManager } = createAdsManager(rootElm, backend, store);

                expect(type).toBe(ACTION_CREATE_ADS_MANAGER);
                expect(adsManager instanceof DecliningAdsManager).toBe(true);
                expect(adsManager._adManager instanceof managerType).toBe(true);
            });
        }

        testCreateAdsManager(BACKEND_MEDIA_PLAYER, IMAManager,
            'should always use the HTML5 IMA SDK for the HTML5 backend');
        testCreateAdsManager(BACKEND_PLAYER_CORE, IMAManager,
            'should always use the HTML5 IMA SDK for the HTML5 backend');
        testCreateAdsManager(BACKEND_HLS, IMAManager,
            'should always use the HTML5 IMA SDK for the HLS backend');
        testCreateAdsManager(BACKEND_FLASH, FlashManager,
            'should use the `FlashManager` when using the flash backend');
    });
});
