import * as AnalyticsTrackerActions from 'actions/analytics-tracker';

class FakeTracker {}

describe('actions | analytics-tracker', function() {
    test('setAnalyticsTracker is formatted correctly', function() {
        const tracker = new FakeTracker();
        const action = AnalyticsTrackerActions.setAnalyticsTracker(tracker);

        const expectedAction = {
            type: AnalyticsTrackerActions.ACTION_SET_ANALYTICS_TRACKER,
            tracker,
        };

        expect(action).toEqual(expectedAction);
    });

    test('trackEvent is formatted correctly', function() {
        const eventName = 'my cool event';
        const eventProperties = {
            prop: 'llama is awesome',
        };
        const action = AnalyticsTrackerActions.trackEvent(eventName, eventProperties);

        const expectedAction = {
            type: AnalyticsTrackerActions.ACTION_TRACK_EVENT,
            eventName,
            eventProperties,
        };

        expect(action).toEqual(expectedAction);
    });
});
