import * as BroadcasterInfoActions from 'actions/broadcaster-info';
import * as api from 'test-utils/utils/api';

describe('actions | broadcaster-info', () => {
    let dispatch;

    beforeEach(() => {
        dispatch = jest.fn();
        api.setLoggedIn(true);
    });

    afterEach(() => {
        api.clearFakeResponses();
    });

    describe('fetchChannelInfo', () => {
        function channelInfoTest(channelName ,isPartner, expectedStatus) {
            test(`isPartner: ${isPartner}`, () => {
                api.expectChannelInfo(channelName, { partner: isPartner });

                const fetchChannelInfoFunc = BroadcasterInfoActions.fetchChannelInfo(channelName);

                return fetchChannelInfoFunc(dispatch).then(() => {
                    expect(dispatch).toHaveBeenCalledWith({
                        channelName,
                        info: {
                            partnerStatus: expectedStatus,
                        },
                        type: BroadcasterInfoActions.ACTION_BROADCASTER_INFO_LOADED,
                    });
                });
            });
        }

        channelInfoTest('channelName', true, BroadcasterInfoActions.BROADCASTER_IS_PARTNER);
        channelInfoTest('channelName2', false, BroadcasterInfoActions.BROADCASTER_IS_NOT_PARTNER);
    });

    describe('fetchStreamInfo', () => {
        function streamInfoTest(channelName, stream, expectedStatus) {
            test(`stream exists: ${!!stream}`, () => {
                const response = api.expectStreamInfo(channelName, !!stream, {}, { stream });

                const fetchStreamInfoFunc = BroadcasterInfoActions.fetchStreamInfo(channelName);

                return fetchStreamInfoFunc(dispatch).then(() => {
                    expect(dispatch).toHaveBeenCalledWith({
                        channelName,
                        info: {
                            stream: response.stream,
                            liveStatus: expectedStatus,
                        },
                        type: BroadcasterInfoActions.ACTION_BROADCASTER_INFO_LOADED,
                    });

                    api.clearFakeResponses();
                });
            });
        }

        streamInfoTest('channelName3', {}, BroadcasterInfoActions.BROADCASTER_IS_LIVE);
        streamInfoTest('channelName4', null, BroadcasterInfoActions.BROADCASTER_IS_NOT_LIVE);
    });
});
