import {
    broadcasterInfo,
    DEFAULT_BROADCASTER_INFO,
    broadcasterLiveStatus,
    broadcasterPartnerStatus,
    broadcasterStream,
} from 'state/broadcaster-info';
import {
    ACTION_BROADCASTER_INFO_LOADED,
    NOT_AVAILABLE,
    BROADCASTER_IS_PARTNER,
    BROADCASTER_IS_NOT_LIVE,
} from 'actions/broadcaster-info';

export const globalState = broadcasterInfoState => ({ broadcasterInfo: broadcasterInfoState });

describe('state | broadcaster-info', function() {
    test('returns the current broadcasterInfo state otherwise', function() {
        const action = {
            type: 'not a real action',
        };
        const actual = broadcasterInfo({
            before: true,
        }, action);
        const expected = {
            before: true,
        };

        expect(actual).toEqual(expected);
    });

    test('updates data when receiving set broadcasterInfo data action with true values', function() {
        const name = 'clintfm';
        const state = DEFAULT_BROADCASTER_INFO;
        const action = {
            type: ACTION_BROADCASTER_INFO_LOADED,
            channelName: name,
            info: {
                liveStatus: BROADCASTER_IS_NOT_LIVE,
                partnerStatus: BROADCASTER_IS_PARTNER,
            },
        };

        expect(broadcasterLiveStatus(globalState(state), name)).toEqual(NOT_AVAILABLE);
        expect(broadcasterPartnerStatus(globalState(state), name)).toEqual(NOT_AVAILABLE);

        const newState = broadcasterInfo(DEFAULT_BROADCASTER_INFO, action);

        expect(broadcasterLiveStatus(globalState(newState), name)).toEqual(BROADCASTER_IS_NOT_LIVE);
        expect(broadcasterPartnerStatus(globalState(newState), name)).toEqual(BROADCASTER_IS_PARTNER);

        expect(newState.allNames).toEqual([name]);
    });

    describe('selector functions', function() {
        const channelName = 'channelName';

        const broadcasterState = (attribute, value) => (
            globalState({
                byName: {
                    [channelName]: {
                        [attribute]: value,
                    },
                },
            })
        );

        test('broadcasterLiveStatus', function() {
            expect(
                broadcasterLiveStatus(
                    broadcasterState('liveStatus', BROADCASTER_IS_NOT_LIVE),
                    channelName
                )
            ).toEqual(
                BROADCASTER_IS_NOT_LIVE
            );
        });

        test('broadcasterPartnerStatus', function() {
            expect(
                broadcasterPartnerStatus(
                    broadcasterState('partnerStatus', BROADCASTER_IS_PARTNER),
                    channelName
                )
            ).toEqual(
                BROADCASTER_IS_PARTNER
            );
        });

        test('broadcasterStream', function() {
            expect(
                broadcasterStream(
                    broadcasterState('stream', {}),
                    channelName
                )
            ).toEqual(
                {}
            );
        });

        test('with no attributes', function() {
            const emptyState = broadcasterState();

            expect(broadcasterLiveStatus(emptyState)).toEqual(NOT_AVAILABLE);
            expect(broadcasterPartnerStatus(emptyState)).toEqual(NOT_AVAILABLE);
            expect(broadcasterStream(emptyState)).toEqual(NOT_AVAILABLE);
        });
    });
});
