import React from 'react';
import renderer from 'react-test-renderer';

import { TwitchLogoSVG } from 'ui/components/common/svg/twitch-logo';
import { ClipsSVG } from 'ui/components/common/svg/clips';
import { ClosedCaptionsSVG } from 'ui/components/common/svg/closed-caption';
import { ExtensionSVG } from 'ui/components/common/svg/extensions';
import { FullscreenSVG } from 'ui/components/common/svg/fullscreen';
import { PauseSVG } from 'ui/components/common/svg/pause';
import { PlaySVG } from 'ui/components/common/svg/play';
import { SettingsSVG } from 'ui/components/common/svg/settings';
import { TheatreSVG } from 'ui/components/common/svg/theatre';
import { VolumeSVG } from 'ui/components/common/svg/volume';
import { AgeGateSVG } from 'ui/components/common/svg/restricted-ages';
import { AgeGateFailedSVG } from 'ui/components/common/svg/age-gate-failed';

function testSnapshot(component, name) {
    describe(`ui | components | common | svg | ${name}`, () => {
        test('snapshot contains correct path description', () => {
            const tree = renderer.
                         create(component).
                         toJSON();
            expect(tree).toMatchSnapshot();
        });
    });
}
//
testSnapshot(<TwitchLogoSVG />, 'twitch logo');
testSnapshot(<ClipsSVG />, 'clips');
testSnapshot(<ClosedCaptionsSVG enabled={true} />, 'closed caption on');
testSnapshot(<ClosedCaptionsSVG enabled={false} />, 'closed caption off');
testSnapshot(<ExtensionSVG />, 'extensions');
testSnapshot(<FullscreenSVG enabled={true} />, 'fullscreen');
testSnapshot(<FullscreenSVG enabled={false} />, 'unfullscreen');
testSnapshot(<PauseSVG />, 'pause');
testSnapshot(<PlaySVG />, 'play');
testSnapshot(<SettingsSVG />, 'settings');
testSnapshot(<TheatreSVG enabled={true} />, 'theatre');
testSnapshot(<TheatreSVG enabled={false} />, 'theatre-deactivated');
testSnapshot(<VolumeSVG muted={false} />, 'volume full');
testSnapshot(<VolumeSVG muted={true} />, 'volume mute');
testSnapshot(<AgeGateSVG requiredAge={19} />, '19 age gate');
testSnapshot(<AgeGateSVG requiredAge={21} />, '21 age gate');
testSnapshot(<AgeGateFailedSVG />, 'age gate failed');
