import React from 'react';
import { shallow } from 'enzyme';
import { SVGWrapper } from 'ui/components/common/svg/svg-wrapper';

const TestComponent = () => <span />;

function renderSVGWrapper(overrides = {}) {
    const component = <SVGWrapper {...overrides} />;
    return shallow(component);
}

describe('ui | components | common | svg | svg wrapper', () => {
    function testProps(testProp) {
        for (const key in testProp) {
            test(`can set ${key} correctly`, () => {
                const testValue = testProps[key];
                const component = renderSVGWrapper({
                    key: testValue,
                });
                expect(component.prop(key)).toBe(testValue);
            });
        }
    }
    testProps({ className: 'test-className' });
    testProps({ className: 'test-className test-className-2 test-ClassName-3' });
    testProps({ id: 'test-id' });
    testProps({ width: '12px' });
    testProps({ height: '64px' });
    testProps({ preserveAspectRatio: 'none' });
    testProps({ preserveAspectRatio: 'xMinYMax meet' });
    testProps({ preserveAspectRatio: 'xMinYMax slice' });
    testProps({ children: <TestComponent /> });
});
