import React from 'react';
import assign from 'lodash/assign';
import { shallow } from 'enzyme';
import renderer from 'react-test-renderer';
import { ToggleFullscreen } from 'ui/components/overlays/toggle-fullscreen-overlay';

const DEFAULT_ARGS = Object.freeze({
    handleDoubleClick() {},
});

function renderToggleFullscreenOverlay(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ToggleFullscreen {...args} />;
    return shallow(component);
}

describe('ui | containers | overlays | toggle fullscreen', () => {
    test('snapshot is correctly matching', () => {
        const tree = renderer.
            create(<ToggleFullscreen {...DEFAULT_ARGS} />).
            toJSON();
        expect(tree).toMatchSnapshot();
    });

    test('renders ToggleFullscreenOverlay with correct state', () => {
        const component = renderToggleFullscreenOverlay();
        expect(component.type()).toBe('div');
    });

    test('should render a div with the correct classes', function() {
        const component = renderToggleFullscreenOverlay();
        const expectedClassNames =  'pl-overlay pl-overlay__fullscreen';
        expect(component.prop('className')).toBe(expectedClassNames);
    });

    test('double click event is called correctly', () => {
        const handleDoubleClick = jest.fn();
        const component = renderToggleFullscreenOverlay({
            handleDoubleClick,
        });

        component.find('.pl-overlay__fullscreen').simulate('doubleclick');
        expect(handleDoubleClick).toHaveBeenCalledTimes(1);
    });
});
