import React from 'react';
import assign from 'lodash/assign';
import { shallow } from 'enzyme';
import ShallowRenderer from 'react-test-renderer/shallow';
import { ClipsModerationMenuComponent } from 'ui/components/settings/clips-moderation-menu';
import { IDENTIFIER_MAIN_MENU } from 'ui/components/settings/menu-manager';

const DEFAULT_ARGS = Object.freeze({
    currentSpeed: 1.0,
    onMenuTransition() {},
    onSelectPlaybackSpeed() {},
    t() {},
});

function renderClipsModerationMenu(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <ClipsModerationMenuComponent {...args} />;
    return shallow(component);
}

describe('ui | components | settings | clips-moderation-menu', function() {
    test('contains expected components', function() {
        const root = window.document.createElement('div');
        const args = assign({}, DEFAULT_ARGS, { root: root });
        const renderer = new ShallowRenderer();
        const tree = renderer.
            render(
                <ClipsModerationMenuComponent {...args} />
            );
        expect(tree).toMatchSnapshot();
    });

    test('when the header is clicked, menu transition to main menu is invoked', function() {
        const transitionSpy = jest.fn();
        const component = renderClipsModerationMenu({
            onMenuTransition: transitionSpy,
        });

        expect(transitionSpy).toHaveBeenCalledTimes(0);
        component.find('button.qa-header-button').simulate('click');

        expect(transitionSpy).toHaveBeenCalledTimes(1);
        expect(transitionSpy).toHaveBeenCalledWith(IDENTIFIER_MAIN_MENU);
    });
});
