import React from 'react';
import { shallow } from 'enzyme';
import assign from 'lodash/assign';
import { BottomLeftControls } from 'ui/components/bottom-controls/bottom-left-controls';
import { BottomRightControls } from 'ui/components/bottom-controls/bottom-right-controls';
import { Seekbar } from 'ui/containers/seekbar';
import { BottomControlsContainer, CONTAINER_CLASSES, mapStateToProps } from 'ui/containers/bottom-controls';
import { SIDEBAR_VIEW, COLLAPSED_VIEW } from 'state/collection';

const DEFAULT_ARGS = Object.freeze({
    getCurrentTime: () => {},
    showBottomControls: true,
});

function renderBottomControls(overrides = {}) {
    const args = assign({}, DEFAULT_ARGS, overrides);
    const component = <BottomControlsContainer {...args} />;
    return shallow(component);
}

describe('ui | components | bottom-controls', function() {
    test('has expected classes', function() {
        const component = renderBottomControls();
        expect(component.hasClass(CONTAINER_CLASSES)).toBeTruthy();
    });

    test('contains a seekbar, bottom left and bottom right controls', function() {
        const component = renderBottomControls();
        expect(component.childAt(0).type()).toBe(Seekbar, 'has seekbar');
        expect(component.childAt(0).prop('getCurrentTime')).toBe(
            DEFAULT_ARGS.getCurrentTime,
            'passes in getCurrentTime prop into seekbar getCurrentTime prop'
        );

        expect(component.childAt(1).type()).toBe(BottomLeftControls, 'has bottom left controls');
        expect(component.childAt(2).type()).toBe(BottomRightControls, 'has bottom right control');
    });

    test('mapStateToProps', () => {
        const collectionSidebarOpen = {
            collection: {
                currentView: SIDEBAR_VIEW,
            },
        };
        const collectionSidebarClosed = {
            collection: {
                currentView: COLLAPSED_VIEW,
            },
        };

        expect(mapStateToProps(collectionSidebarOpen).showBottomControls).toBe(false);
        expect(mapStateToProps(collectionSidebarClosed).showBottomControls).toBe(true);
    });
});
