import React from 'react';
import assign from 'lodash/assign';
import { shallow } from 'enzyme';
import {
    ClipPlayButtonOverlayContainer,
    mapStateToProps,
} from 'ui/player-types/clips/overlays/clip-play-button-overlay-container';
import { PlayButtonOverlay as PlayButtonOverlayComponent } from 'ui/components/overlays/play-button-overlay';

const DEFAULT_PROPS = Object.freeze({
    showOverlay: true,
    play: jest.fn(),
});

function renderContainer(overrides = {}) {
    const args = assign({}, DEFAULT_PROPS, overrides);
    const component = <ClipPlayButtonOverlayContainer {...args} />;
    return shallow(component);
}

describe('ui | player-types | clips | overlays | clip-play-button-overlay-container', () => {
    test('correctly maps state to props', () => {
        const state = {
            playback: {
                hasPlayed: false,
                isLoading: false,
            },
        };

        expect(mapStateToProps(state)).toEqual({
            showOverlay: true,
        });
    });

    test('correctly renders the play button overlay', () => {
        const container = renderContainer();

        expect(container.find(PlayButtonOverlayComponent).length).toEqual(1);
        expect(container.find(PlayButtonOverlayComponent).prop('onClick')).toEqual(DEFAULT_PROPS.play);
    });
});
