import { ClipsMinutesWatched } from 'ui/player-types/clips/utils/tracking/clips-minutes-watched';
import { TRACKING_CLIPS_MINUTE } from 'ui/player-types/clips/utils/tracking/clips-tracking-constants';

describe('ui | player-types | clips | utils | tracking | clips-minutes-watched', () => {
    let store;
    let state;
    let clipsTrackEventSpy;
    let clipsMinWatched;

    beforeEach(() => {
        clipsTrackEventSpy = jest.fn();

        state = {
            analyticsTracker: {
                clipsTrackEvent: clipsTrackEventSpy,
            },
            playback: {
                playing: false,
                paused: true,
            },
        };

        store = {
            getState: () => state,
            subscribe() {},
        };

        clipsMinWatched = new ClipsMinutesWatched(store);
    });

    describe('ClipsMinutesWatched', () => {
        test('tracking should call clipsTrackEvent', () => {
            expect(clipsTrackEventSpy).not.toHaveBeenCalled();
            clipsMinWatched.minWatchedEmitter.initialDelay = 10;

            clipsMinWatched.trackClipsMinuteWatched();

            expect(clipsTrackEventSpy).toHaveBeenCalledWith(
                TRACKING_CLIPS_MINUTE,
                {
                    /* eslint-disable camelcase */
                    minutes_logged: 0,
                    seconds_offset: 0.01,
                    /* eslint-enable camelcase */
                }
            );
        });

        test('should start tracking when it is not tracking but the video is playing', () => {
            clipsMinWatched.minWatchedEmitter.isCurrentlyTracking = () => false;

            clipsMinWatched.minWatchedEmitter.start = jest.fn();
            clipsMinWatched.minWatchedEmitter.stop = jest.fn();

            expect(clipsMinWatched.minWatchedEmitter.start).not.toHaveBeenCalled();
            expect(clipsMinWatched.minWatchedEmitter.stop).not.toHaveBeenCalled();

            clipsMinWatched.handlePlaybackChange({
                playing: true,
                paused: false,
            });

            expect(clipsMinWatched.minWatchedEmitter.start).toHaveBeenCalled();
            expect(clipsMinWatched.minWatchedEmitter.stop).not.toHaveBeenCalled();
        });

        test('should stop tracking when it is tracking but the video is not playing', () => {
            clipsMinWatched.minWatchedEmitter.isCurrentlyTracking = () => true;

            clipsMinWatched.minWatchedEmitter.start = jest.fn();
            clipsMinWatched.minWatchedEmitter.stop = jest.fn();

            expect(clipsMinWatched.minWatchedEmitter.start).not.toHaveBeenCalled();
            expect(clipsMinWatched.minWatchedEmitter.stop).not.toHaveBeenCalled();

            clipsMinWatched.handlePlaybackChange({
                playing: false,
                paused: true,
            });

            expect(clipsMinWatched.minWatchedEmitter.start).not.toHaveBeenCalled();
            expect(clipsMinWatched.minWatchedEmitter.stop).toHaveBeenCalled();
        });
    });
});
