import sinon from 'sinon';

export class FakeGoogle {
    constructor() {
        const adsLoader = {
            addEventListener: () => {},
            requestAds: () => {},
            destroy: sinon.spy(),
        };
        const adsManagerLoadedEvent = {
            Type: {
                ADS_MANAGER_LOADED: 'adsManagerLoaded',
            },
        };
        const adEvent = {
            Type: {
                ALL_ADS_COMPLETED: 'allAdsCompleted',
                COMPLETE: 'complete',
                CONTENT_PAUSE_REQUESTED: 'contentPauseRequested',
                CONTENT_RESUME_REQUESTED: 'contentResumeRequested',
                LOADED: 'loaded',
                PAUSED: 'pause',
                RESUMED: 'resume',
                STARTED: 'start',
                VOLUME_CHANGED: 'volumeChange',
                VOLUME_MUTED: 'mute',
            },
        };
        const adErrorEvent = {
            Type: {
                AD_ERROR: 'adError',
            },
        };
        const adsRequest = {
            requestAds: () => {},
        };
        const adsManager = {
            init: () => {},
            addEventListener: () => {},
            setVolume: () => {},
            getVolume: () => {
                return 0;
            },
            start: () => {},
            destroy: () => {},
        };
        const adsRenderingSettings = {
            getAdsManager: () => {
                return adsManager;
            },
        };

        this.ima = {
            settings: {
                setVpaidMode: sinon.spy(),
            },
            ViewMode: {
                NORMAL: 'normal',
            },
            ImaSdkSettings: {
                VpaidMode: {
                    ENABLED: 'enabled',
                    DISABLED: 'disabled',
                    INSECURE: 2,
                },
            },
            AdsManagerLoadedEvent: adsManagerLoadedEvent,
            AdErrorEvent: adErrorEvent,
            AdEvent: adEvent,
            AdDisplayContainer: sinon.stub().returns({
                initialize: sinon.spy(),
                destroy: sinon.spy(),
            }),
            AdsLoader: sinon.stub().returns(adsLoader),
            AdsRenderingSettings: () => {
                return adsRenderingSettings;
            },
            AdsRequest: () => {
                return adsRequest;
            },
        };
    }
}
