import merge from 'lodash/assign';

import { FakeGoogle } from './google.fake.js';

export function buildFakeWindow(customization) {
    return merge(
        {},
        {
            addEventListener: jest.fn(),
            google: new FakeGoogle(),
            document: {},
            clearTimeout: jest.fn(),
            setTimeout: jest.fn(delayedFn => {
                delayedFn();
                return Math.floor(Math.random() * 999);
            }),
            clearInterval: jest.fn(),
            setInterval: jest.fn(delayedFn => {
                delayedFn();
                return Math.floor(Math.random() * 999);
            }),
            location: {
                search: '',
            },
            open: jest.fn(),
            navigator: {
                userAgent: '',
            },
        },
        customization
    );
}
