import assign from 'lodash/assign';

/* eslint-disable camelcase */
/* eslint-disable max-len */
export const CLIP_RESPONSE_FULL = Object.freeze({
    broadcast_id: '23242527584',
    broadcaster: {
        channel_url: 'https://www.twitch.tv/nightblue3',
        display_name: 'Nightblue3',
        id: '26946000',
        logo: 'https://static-cdn.jtvnw.net/jtv_user_pictures/a7eb6cdf-ed7e-43ab-a2ff-0036fd1d3d87-profile_image-150x150.png',
        name: 'nightblue3',
    },
    created_at: '2016-09-23T17:07:39Z',
    curator: {
        channel_url: 'https://www.twitch.tv/syntheticcfm',
        display_name: 'SyntheticCFM',
        id: '78456568',
        logo: 'https://static-cdn.jtvnw.net/jtv_user_pictures/32f7a97a0f8e1050-profile_image-150x150.jpeg',
        name: 'syntheticcfm',
    },
    duration: 30,
    embed_html: '<iframe src="https://clips.twitch.tv/embed?clip=FrailQuaintHeronRuleFive&tt_medium=clips_api&tt_content=embed" width="640" height="360" frameborder="0" scrolling="no" allowfullscreen="true"></iframe>',
    embed_url: 'https://clips.twitch.tv/embed?clip=FrailQuaintHeronRuleFive&tt_medium=clips_api&tt_content=embed',
    game: 'League of Legends',
    language: 'en',
    slug: 'FrailQuaintHeronRuleFive',
    thumbnails: {
        medium: 'https://clips-media-assets.twitch.tv/23242527584-offset-10666-preview-480x272.jpg',
        small: 'https://clips-media-assets.twitch.tv/23242527584-offset-10666-preview-260x147.jpg',
        tiny: 'https://clips-media-assets.twitch.tv/23242527584-offset-10666-preview-86x45.jpg',
    },
    title: 'hi',
    tracking_id: '29332463',
    url: 'https://clips.twitch.tv/FrailQuaintHeronRuleFive?tt_medium=clips_api&tt_content=url',
    views: 1124,
    vod: {
        id: '203487460',
        offset: 9260,
        url: 'https://www.twitch.tv/videos/203487460?t=2h34m20s',
        preview_image_url: 'url.com',
    },
    segments: [
        {
            playback_offset: 0,
            offset: 74.1666666666667,
            duration: 4.166666666666671,
            speed: 1,
        },
        {
            playback_offset: 4.166666666666671,
            offset: 78.33333333333337,
            duration: 2,
            speed: 0.5,
        },
        {
            playback_offset: 6.166666666666671,
            offset: 80.33333333333337,
            duration: 2.833333333333332,
            speed: 1,
        },
    ],
});
/* eslint-enable max-len */

export const CLIP_RESPONSE_MINIMUM = Object.freeze(assign(
    {},
    CLIP_RESPONSE_FULL,
    {
        vod: null,
        game: null,
        segments: null,
    }
));
/* eslint-enable camelcase */

export const createClipMetadataFromResponse = response => {
    const baseClipProperties = {
        channel: {
            channelUrl: response.broadcaster.channel_url,
            displayName: response.broadcaster.display_name,
            name: response.broadcaster.name,
            id: response.broadcaster.id,
            logo: response.broadcaster.logo,
        },
        curator: {
            channelUrl: response.curator.channel_url,
            displayName: response.curator.display_name,
            name: response.curator.name,
            id: response.curator.id,
            logo: response.curator.logo,
        },
        game: response.game,
        url: response.url,
        title: response.title,
        thumbnails: response.thumbnails,
        createdAt: response.created_at,
        duration: response.duration,
        embedHtml: response.embed_html,
        embedUrl: response.embed_url,
        language: response.language,
        slug: response.slug,
        viewCount: response.views,
        clipHasVod: false,
        segments: response.segments,
    };

    const additionalClipProperties = {};

    if (response.vod) {
        additionalClipProperties.clipVideoId = response.vod.id;
        additionalClipProperties.clipVideoOffset = response.vod.offset;
        additionalClipProperties.clipVideoUrl = response.vod.url;
        additionalClipProperties.clipVideoPreviewImageUrl = response.vod.preview_image_url;
        additionalClipProperties.clipHasVod = true;
    }

    return assign(baseClipProperties, additionalClipProperties);
};

export const clipStreamMetadata = createClipMetadataFromResponse(CLIP_RESPONSE_FULL);
export const clipStreamMetadataMinumum = createClipMetadataFromResponse(CLIP_RESPONSE_FULL);
