import assign from 'lodash/assign';

/* eslint-disable camelcase */
export const TEST_COLLECTION_METADATA = Object.freeze({
    _id: '123123123',
    created_at: new Date(123).toString(),
    updated_at: new Date(456).toString(),
    owner: {
        _id: 'some_collection_owner',
        display_name: 'SomeCollectionOwner',
        name: 'some_collection_owner',
        type: 'wat',
        bio: 'Hallo Frans',
    },
    state: 'public',
    thumbnails: {
        large: 'https://stubbed-thumbnails.tv/large.png',
        medium: 'https://stubbed-thumbnails.tv/medium.png',
        small: 'https://stubbed-thumbnails.tv/small.png',
        template: 'https://stubbed-thumbnails.tv/template.png',
    },
    title: 'Collection of the edgiest moments of all time',
    total_duration: 10921050, // 3 hours 2 mins 1 sec 50 ms
    views: 12345,
    items_count: 30,
});

export const TEST_COLLECTION_ITEMS = [
    // item without thumbnail set
    {
        _id: 'vod1_id',
        item_type: 'video',
        item_id: '111111',
        owner: {
            _id: 'edgy_user111',
            display_name: 'EdGy_UsEr111',
            name: 'edgy_user111',
        },
        title: 'Number 1 edgiest video of all time',
        description_html: 'Opening the convenience store (automatic) door with my mind',
        duration: 5460525, // half of total duration
        views: 111,
    },
    // 1st item with thumbnail set
    {
        _id: 'vod2_id',
        item_type: 'video',
        item_id: '222222',
        owner: {
            _id: 'edgy_user222',
            display_name: 'EdGy_UsEr222',
            name: 'edgy_user222',
        },
        title: 'Number 2 edgiest video of all time',
        description_html: 'Levitating (spoiler: feet at the edge of the escalator step)',
        duration: 2730263, // quarter of total duration
        thumbnails: {
            large: 'https://stubbed-thumbnails.tv/vod1-large.png',
            medium: 'https://stubbed-thumbnails.tv/vod1-medium.png',
            small: 'https://stubbed-thumbnails.tv/vod1-small.png',
            template: 'https://stubbed-thumbnails.tv/vod1-template.png',
        },
        views: 222,
    },
    // 2nd item with thumbnail set
    {
        _id: 'vod3_id',
        item_type: 'video',
        item_id: '333333',
        owner: {
            _id: 'edgy_user333',
            display_name: 'EdGy_UsEr333',
            name: 'edgy_user333',
        },
        title: 'Number 3 edgiest video of all time',
        description_html: 'Gotta go fast, gotta go fast',
        duration: 2730262, // half of total duration
        thumbnails: {
            large: 'https://stubbed-thumbnails.tv/vod2-large.png',
            medium: 'https://stubbed-thumbnails.tv/vod2-medium.png',
            small: 'https://stubbed-thumbnails.tv/vod2-small.png',
            template: 'https://stubbed-thumbnails.tv/vod2-template.png',
        },
        views: 333,
    },
];

export const TEST_NORMALIZED_COLLECTION_ITEMS = [
    // item without thumbnail set
    {
        itemId: '111111',
        owner: {
            displayName: 'EdGy_UsEr111',
        },
        title: 'Number 1 edgiest video of all time',
        thumbnails: {
            small: 'https://static-cdn.jtvnw.net/ttv-playlists-thumbnails-prod/no-thumbnail-sm.png',
        },
    },
    // 1st item with thumbnail set
    {
        itemId: '222222',
        owner: {
            displayName: 'EdGy_UsEr222',
        },
        title: 'Number 2 edgiest video of all time',
        thumbnails: {
            small: 'https://stubbed-thumbnails.tv/vod1-small.png',
        },
    },
    // 2nd item with thumbnail set
    {
        itemId: '333333',
        owner: {
            displayName: 'EdGy_UsEr333',
        },
        title: 'Number 3 edgiest video of all time',
        thumbnails: {
            small: 'https://stubbed-thumbnails.tv/vod2-small.png',
        },
    },
];

export const TEST_NORMALIZED_COLLECTION_METADATA = Object.freeze({
    id: '123123123',
    owner: {
        id: 'some_collection_owner',
        displayName: 'SomeCollectionOwner',
        name: 'some_collection_owner',
    },
    thumbnails: {
        large: 'https://stubbed-thumbnails.tv/large.png',
        medium: 'https://stubbed-thumbnails.tv/medium.png',
        small: 'https://stubbed-thumbnails.tv/small.png',
        template: 'https://stubbed-thumbnails.tv/template.png',
    },
    title: 'Collection of the edgiest moments of all time',
    totalDuration: 10921050, // 3 hours 2 mins 1 sec 50 ms
    views: 12345,
});

export const TEST_NORMALIZED_FEATURED_COLLECTION_METADATA = Object.freeze({
    id: '123123123',
    owner: {
        id: 'some_collection_owner',
        displayName: 'SomeCollectionOwner',
        name: 'some_collection_owner',
    },
    thumbnails: {
        large: 'https://stubbed-thumbnails.tv/large.png',
        medium: 'https://stubbed-thumbnails.tv/medium.png',
        small: 'https://stubbed-thumbnails.tv/small.png',
        template: 'https://stubbed-thumbnails.tv/template.png',
    },
    title: 'Collection of the edgiest moments of all time',
    itemsCount: 30,
});

export const TEST_COLLECTION = assign({}, TEST_COLLECTION_METADATA, {
    items: TEST_COLLECTION_ITEMS,
});

export const TEST_NORMALIZED_COLLECTION = assign({}, TEST_NORMALIZED_COLLECTION_METADATA, {
    items: TEST_NORMALIZED_COLLECTION_ITEMS,
});
/* eslint-enable camelcase */
